/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public abstract class EndCaveFeature
extends DefaultFeature {
    private static int errCounter = 0;
    protected static final BlockState CAVE_AIR = Blocks.f_50627_.m_49966_();
    protected static final BlockState END_STONE = Blocks.f_50259_.m_49966_();
    protected static final BlockState WATER = Blocks.f_49990_.m_49966_();
    private static final Vec3i[] SPHERE;

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        if (pos.m_123341_() * pos.m_123341_() + pos.m_123343_() * pos.m_123343_() <= 2500) {
            return false;
        }
        if (this.biomeMissingCaves(world, pos)) {
            return false;
        }
        int radius = MHelper.randRange((int)10, (int)30, (RandomSource)random);
        BlockPos center = this.findPos(world, pos, radius, random);
        if (center == null) {
            return false;
        }
        BiomePicker.ActualBiome biome = EndBiomes.getCaveBiome(pos.m_123341_(), pos.m_123343_());
        Set<BlockPos> caveBlocks = this.generate(world, center, radius, random);
        if (!caveBlocks.isEmpty()) {
            if (biome != null) {
                ChunkGenerator generator = featureConfig.m_159775_();
                this.setBiomes(world, biome, caveBlocks);
                Set floorPositions = Sets.newConcurrentHashSet();
                Set ceilPositions = Sets.newConcurrentHashSet();
                caveBlocks.parallelStream().forEach(bpos -> {
                    if (world.m_8055_(bpos).m_247087_()) {
                        BlockPos side = bpos.m_7495_();
                        if (world.m_8055_(side).m_204336_(CommonBlockTags.GEN_END_STONES)) {
                            floorPositions.add(side);
                        }
                        if (world.m_8055_(side = bpos.m_7494_()).m_204336_(CommonBlockTags.GEN_END_STONES)) {
                            ceilPositions.add(side);
                        }
                    }
                });
                BlockState surfaceBlock = EndBiome.findTopMaterial(biome.bclBiome);
                BCLBiome bCLBiome = biome.bclBiome;
                if (bCLBiome instanceof EndCaveBiome) {
                    EndCaveBiome caveBiome = (EndCaveBiome)bCLBiome;
                    this.placeFloor(world, generator, (EndCaveBiome)biome.bclBiome, floorPositions, random, surfaceBlock);
                    this.placeCeil(world, generator, (EndCaveBiome)biome.bclBiome, ceilPositions, random);
                    this.placeWalls(world, generator, (EndCaveBiome)biome.bclBiome, caveBlocks, random);
                } else if (Configs.MAIN_CONFIG.verboseLogging() && errCounter < 25) {
                    ++errCounter;
                    BetterEnd.LOGGER.error(biome.bclBiome.getID() + " is not an EndCaveBiome.");
                }
            }
            this.fixBlocks(world, caveBlocks);
        }
        return true;
    }

    protected abstract Set<BlockPos> generate(WorldGenLevel var1, BlockPos var2, int var3, RandomSource var4);

    protected void placeFloor(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> floorPositions, RandomSource random, BlockState surfaceBlock) {
        float density = biome.getFloorDensity();
        floorPositions.forEach(pos -> {
            Holder<? extends ConfiguredFeature<?, ?>> feature;
            if (!surfaceBlock.m_60713_(Blocks.f_50259_)) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)surfaceBlock);
            }
            if (density > 0.0f && random.m_188501_() <= density && (feature = biome.getFloorFeature(random)) != null && feature.m_203633_()) {
                ((ConfiguredFeature)feature.m_203334_()).m_224953_(world, generator, random, pos.m_7494_());
            }
        });
    }

    protected void placeCeil(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> ceilPositions, RandomSource random) {
        float density = biome.getCeilDensity();
        ceilPositions.forEach(pos -> {
            Holder<? extends ConfiguredFeature<?, ?>> feature;
            BlockState ceilBlock = biome.getCeil((BlockPos)pos);
            if (ceilBlock != null) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)ceilBlock);
            }
            if (density > 0.0f && random.m_188501_() <= density && (feature = biome.getCeilFeature(random)) != null && feature.m_203633_()) {
                ((ConfiguredFeature)feature.m_203334_()).m_224953_(world, generator, random, pos.m_7495_());
            }
        });
    }

    protected void placeWalls(WorldGenLevel world, ChunkGenerator generator, EndCaveBiome biome, Set<BlockPos> positions, RandomSource random) {
        HashSet placed = Sets.newHashSet();
        positions.forEach(pos -> {
            BlockState wallBlock;
            if (random.m_188503_(4) == 0 && this.hasOpenSide((BlockPos)pos, positions) && (wallBlock = biome.getWall((BlockPos)pos)) != null) {
                for (Vec3i offset : SPHERE) {
                    BlockPos wallPos = pos.m_121955_(offset);
                    if (positions.contains(wallPos) || placed.contains(wallPos) || !world.m_8055_(wallPos).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
                    wallBlock = biome.getWall(wallPos);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)wallPos, (BlockState)wallBlock);
                    placed.add(wallPos);
                }
            }
        });
    }

    private boolean hasOpenSide(BlockPos pos, Set<BlockPos> positions) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (positions.contains(pos.m_121945_(dir))) continue;
            return true;
        }
        return false;
    }

    protected void setBiomes(WorldGenLevel world, BiomePicker.ActualBiome biome, Set<BlockPos> blocks) {
        blocks.forEach(pos -> this.setBiome(world, (BlockPos)pos, biome));
    }

    protected void setBiome(WorldGenLevel world, BlockPos pos, BiomePicker.ActualBiome biome) {
        BiomeAPI.setBiome((LevelAccessor)world, (BlockPos)pos, (Holder)biome.biome);
    }

    private BlockPos findPos(WorldGenLevel world, BlockPos pos, int radius, RandomSource random) {
        int top = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_());
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
        bpos.m_142451_(pos.m_123341_());
        bpos.m_142443_(pos.m_123343_());
        bpos.m_142448_(top - 1);
        BlockState state = world.m_8055_((BlockPos)bpos);
        while (!state.m_204336_(CommonBlockTags.GEN_END_STONES) && bpos.m_123342_() > 5) {
            bpos.m_142448_(bpos.m_123342_() - 1);
            state = world.m_8055_((BlockPos)bpos);
        }
        if (bpos.m_123342_() < 10) {
            return null;
        }
        top = (int)((float)bpos.m_123342_() - ((float)radius * 1.3f + 5.0f));
        while (state.m_204336_(CommonBlockTags.GEN_END_STONES) || !state.m_60819_().m_76178_() && bpos.m_123342_() > 5) {
            bpos.m_142448_(bpos.m_123342_() - 1);
            state = world.m_8055_((BlockPos)bpos);
        }
        int bottom = (int)((float)bpos.m_123342_() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return null;
        }
        return new BlockPos(pos.m_123341_(), MHelper.randRange((int)bottom, (int)top, (RandomSource)random), pos.m_123343_());
    }

    protected void fixBlocks(WorldGenLevel world, Set<BlockPos> caveBlocks) {
        BlockPos pos = caveBlocks.iterator().next();
        BlockPos.MutableBlockPos start = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        BlockPos.MutableBlockPos end = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        caveBlocks.forEach(bpos -> {
            if (bpos.m_123341_() < start.m_123341_()) {
                start.m_142451_(bpos.m_123341_());
            }
            if (bpos.m_123341_() > end.m_123341_()) {
                end.m_142451_(bpos.m_123341_());
            }
            if (bpos.m_123342_() < start.m_123342_()) {
                start.m_142448_(bpos.m_123342_());
            }
            if (bpos.m_123342_() > end.m_123342_()) {
                end.m_142448_(bpos.m_123342_());
            }
            if (bpos.m_123343_() < start.m_123343_()) {
                start.m_142443_(bpos.m_123343_());
            }
            if (bpos.m_123343_() > end.m_123343_()) {
                end.m_142443_(bpos.m_123343_());
            }
        });
        BlockFixer.fixBlocks((LevelAccessor)world, start.m_7918_(-2, -2, -2), end.m_7918_(2, 2, 2));
    }

    protected boolean isWaterNear(WorldGenLevel world, BlockPos pos) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (world.m_6425_(pos.m_5484_(dir, 5)).m_76178_()) continue;
            return true;
        }
        return false;
    }

    protected boolean biomeMissingCaves(WorldGenLevel world, BlockPos pos) {
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                Holder biome = world.m_204166_(pos.m_7918_(x << 4, 0, z << 4));
                BCLBiome bclBiome = BiomeAPI.getBiome((Holder)biome);
                boolean hasCaves = true;
                if (bclBiome instanceof EndBiome) {
                    EndBiome endBiome = (EndBiome)bclBiome;
                    hasCaves = endBiome.hasCaves();
                }
                if (hasCaves || BCLBiomeRegistry.isEmptyBiome((BCLBiome)bclBiome) || !BiomeAPI.wasRegisteredAsEndLandBiome((ResourceLocation)bclBiome.getID())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ArrayList prePos = Lists.newArrayList();
        int radius = 5;
        int r2 = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            int x2 = x * x;
            for (int y = -radius; y <= radius; ++y) {
                int y2 = y * y;
                for (int z = -radius; z <= radius; ++z) {
                    int z2 = z * z;
                    if (x2 + y2 + z2 >= r2) continue;
                    prePos.add(new Vec3i(x, y, z));
                }
            }
        }
        SPHERE = prePos.toArray(new Vec3i[0]);
    }
}

