/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.SulphurCrystalBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class SulphuricCaveFeature
extends DefaultFeature {
    private static final BlockState CAVE_AIR = Blocks.f_50627_.m_49966_();
    private static final BlockState WATER = Blocks.f_49990_.m_49966_();
    private static final Direction[] HORIZONTAL = BlocksHelper.makeHorizontal();

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        int radius = MHelper.randRange((int)10, (int)30, (RandomSource)random);
        int top = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_());
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
        bpos.m_142451_(pos.m_123341_());
        bpos.m_142443_(pos.m_123343_());
        bpos.m_142448_(top - 1);
        BlockState state = world.m_8055_((BlockPos)bpos);
        while (!state.m_204336_(CommonBlockTags.GEN_END_STONES) && bpos.m_123342_() > 5) {
            bpos.m_142448_(bpos.m_123342_() - 1);
            state = world.m_8055_((BlockPos)bpos);
        }
        if (bpos.m_123342_() < 10) {
            return false;
        }
        top = (int)((float)bpos.m_123342_() - ((float)radius * 1.3f + 5.0f));
        while (state.m_204336_(CommonBlockTags.GEN_END_STONES) || !state.m_60819_().m_76178_() && bpos.m_123342_() > 5) {
            bpos.m_142448_(bpos.m_123342_() - 1);
            state = world.m_8055_((BlockPos)bpos);
        }
        int bottom = (int)((float)bpos.m_123342_() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return false;
        }
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        pos = new BlockPos(pos.m_123341_(), MHelper.randRange((int)bottom, (int)top, (RandomSource)random), pos.m_123343_());
        OpenSimplexNoise noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)pos.m_123341_(), (int)pos.m_123343_()));
        int x1 = pos.m_123341_() - radius - 5;
        int z1 = pos.m_123343_() - radius - 5;
        int x2 = pos.m_123341_() + radius + 5;
        int z2 = pos.m_123343_() + radius + 5;
        int y1 = MHelper.floor((double)((double)pos.m_123342_() - (double)(radius + 5) / 1.6));
        int y2 = MHelper.floor((double)((double)pos.m_123342_() + (double)(radius + 5) / 1.6));
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        HashSet brimstone = Sets.newHashSet();
        BlockState rock = EndBlocks.SULPHURIC_ROCK.stone.m_49966_();
        int waterLevel = pos.m_123342_() + MHelper.randRange((int)MHelper.floor((double)((double)radius * 0.8)), (int)radius, (RandomSource)random);
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - pos.m_123341_();
            xsq *= xsq;
            mut.m_142451_(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - pos.m_123343_();
                zsq *= zsq;
                mut.m_142443_(z);
                for (int y = y1; y <= y2; ++y) {
                    int ysq = y - pos.m_123342_();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    mut.m_142448_(y);
                    double r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r + 5.0;
                    double dist = xsq + ysq + zsq;
                    if (dist < r * r) {
                        state = world.m_8055_((BlockPos)mut);
                        if (!this.isReplaceable(state)) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)(y < waterLevel ? WATER : CAVE_AIR));
                        continue;
                    }
                    if (!(dist < r2 * r2) || !(state = world.m_8055_((BlockPos)mut)).m_204336_(CommonBlockTags.GEN_END_STONES) && !state.m_60713_(Blocks.f_50016_)) continue;
                    double v = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) + noise.eval((double)x * 0.03, (double)y * 0.03, (double)z * 0.03) * 0.5;
                    if (v > 0.4) {
                        brimstone.add(mut.m_7949_());
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)rock);
                }
            }
        }
        brimstone.forEach(blockPos -> this.placeBrimstone(world, (BlockPos)blockPos, random));
        if (random.m_188503_(4) == 0) {
            int count = MHelper.randRange((int)5, (int)20, (RandomSource)random);
            for (int i = 0; i < count; ++i) {
                mut.m_122190_((Vec3i)pos).m_122184_(MHelper.floor((double)(random.m_188583_() * 2.0 + 0.5)), 0, MHelper.floor((double)(random.m_188583_() * 2.0 + 0.5)));
                int dist = MHelper.floor((double)(3.0f - MHelper.length((float)(mut.m_123341_() - pos.m_123341_()), (float)(mut.m_123343_() - pos.m_123343_())))) + random.m_188503_(2);
                if (dist <= 0) continue;
                state = world.m_8055_((BlockPos)mut);
                while (!state.m_60819_().m_76178_() || state.m_204336_(CommonBlockTags.WATER_PLANT)) {
                    mut.m_142448_(mut.m_123342_() - 1);
                    state = world.m_8055_((BlockPos)mut);
                }
                if (!state.m_204336_(CommonBlockTags.GEN_END_STONES) || world.m_8055_(mut.m_7494_()).m_60713_(EndBlocks.HYDROTHERMAL_VENT)) continue;
                for (int j = 0; j <= dist; ++j) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.SULPHURIC_ROCK.stone);
                    MHelper.shuffle((Object[])HORIZONTAL, (RandomSource)random);
                    for (Direction dir : HORIZONTAL) {
                        BlockPos p = mut.m_121945_(dir);
                        if (!random.m_188499_() || !world.m_8055_(p).m_60713_(Blocks.f_49990_)) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)((BlockState)EndBlocks.TUBE_WORM.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)dir)));
                    }
                    mut.m_142448_(mut.m_123342_() + 1);
                }
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (Block)EndBlocks.HYDROTHERMAL_VENT);
                mut.m_142448_(mut.m_123342_() + 1);
                state = world.m_8055_((BlockPos)mut);
                while (state.m_60713_(Blocks.f_49990_)) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)EndBlocks.VENT_BUBBLE_COLUMN.m_49966_());
                    world.m_186460_(mut.m_7949_(), EndBlocks.VENT_BUBBLE_COLUMN, MHelper.randRange((int)8, (int)32, (RandomSource)random));
                    mut.m_142448_(mut.m_123342_() + 1);
                    state = world.m_8055_((BlockPos)mut);
                }
            }
        }
        BlockFixer.fixBlocks((LevelAccessor)world, new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2));
        return true;
    }

    private boolean isReplaceable(BlockState state) {
        return state.m_204336_(CommonBlockTags.GEN_END_STONES) || state.m_60713_(EndBlocks.HYDROTHERMAL_VENT) || state.m_60713_(EndBlocks.VENT_BUBBLE_COLUMN) || state.m_60713_(EndBlocks.SULPHUR_CRYSTAL) || BlocksHelper.replaceableOrPlant((BlockState)state) != false || state.m_204336_(CommonBlockTags.WATER_PLANT) || state.m_204336_(BlockTags.f_13035_);
    }

    private void placeBrimstone(WorldGenLevel world, BlockPos pos, RandomSource random) {
        BlockState state = this.getBrimstone(world, pos);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        if (((Boolean)state.m_61143_((Property)EndBlockProperties.ACTIVE)).booleanValue()) {
            this.makeShards(world, pos, random);
        }
    }

    private BlockState getBrimstone(WorldGenLevel world, BlockPos pos) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (!world.m_8055_(pos.m_121945_(dir)).m_60713_(Blocks.f_49990_)) continue;
            return (BlockState)EndBlocks.BRIMSTONE.m_49966_().m_61124_((Property)EndBlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return EndBlocks.BRIMSTONE.m_49966_();
    }

    private void makeShards(WorldGenLevel world, BlockPos pos, RandomSource random) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            BlockPos side;
            if (random.m_188503_(16) != 0 || !world.m_8055_(side = pos.m_121945_(dir)).m_60713_(Blocks.f_49990_)) continue;
            BlockState state = (BlockState)((BlockState)((BlockState)EndBlocks.SULPHUR_CRYSTAL.m_49966_().m_61124_((Property)SulphurCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SulphurCrystalBlock.FACING, (Comparable)dir)).m_61124_((Property)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(random.m_188503_(3)));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)side, (BlockState)state);
        }
    }
}

