/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.land;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.api.v2.levelgen.surface.rules.SwitchRuleSource;
import org.betterx.bclib.interfaces.NumericProvider;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.surface.UmbraSurfaceNoiseCondition;

public class UmbraValleyBiome
extends EndBiome.Config {
    private static final Block[] SURFACE_BLOCKS = new Block[]{EndBlocks.PALLIDIUM_FULL, EndBlocks.PALLIDIUM_HEAVY, EndBlocks.PALLIDIUM_THIN, EndBlocks.PALLIDIUM_TINY, EndBlocks.UMBRALITH.stone};

    public UmbraValleyBiome() {
        super("umbra_valley");
    }

    @Override
    protected void addCustomBuildData(BCLBiomeBuilder builder) {
        builder.fogColor(100, 100, 100).plantsColor(172, 189, 190).waterAndFogColor(69, 104, 134).particles((ParticleOptions)EndParticles.AMBER_SPHERE, 1.0E-4f).loop(EndSounds.UMBRA_VALLEY).music(EndSounds.MUSIC_DARK).feature(EndFeatures.UMBRALITH_ARCH).feature(EndFeatures.THIN_UMBRALITH_ARCH).feature(EndFeatures.INFLEXIA).feature(EndFeatures.FLAMMALIX);
    }

    @Override
    protected SurfaceMaterialProvider surfaceMaterial() {
        return new EndBiome.DefaultSurfaceMaterialProvider(){

            @Override
            public BlockState getTopMaterial() {
                return EndBlocks.UMBRALITH.stone.m_49966_();
            }

            @Override
            public BlockState getUnderMaterial() {
                return EndBlocks.UMBRALITH.stone.m_49966_();
            }

            @Override
            public BlockState getAltTopMaterial() {
                return EndBlocks.PALLIDIUM_FULL.m_49966_();
            }

            @Override
            public boolean generateFloorRule() {
                return false;
            }

            @Override
            public SurfaceRuleBuilder surface() {
                return super.surface().rule(2, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)new SwitchRuleSource((NumericProvider)new UmbraSurfaceNoiseCondition(), List.of(SurfaceRules.m_189390_((BlockState)UmbraValleyBiome.this.surfaceMaterial().getAltTopMaterial()), PALLIDIUM_HEAVY, PALLIDIUM_THIN, PALLIDIUM_TINY, SurfaceRules.m_189390_((BlockState)UmbraValleyBiome.this.surfaceMaterial().getTopMaterial())))));
            }
        };
    }

    public static Block getSurface(int x, int z) {
        return SURFACE_BLOCKS[UmbraSurfaceNoiseCondition.getDepth(x, z)];
    }
}

