/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.rituals;

import com.google.common.collect.Sets;
import java.awt.Point;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.blocks.EndPortalBlock;
import org.betterx.betterend.blocks.RunedFlavolite;
import org.betterx.betterend.blocks.entities.EternalPedestalEntity;
import org.betterx.betterend.network.RitualUpdate;
import org.betterx.betterend.portal.PortalBuilder;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndPortals;
import org.jetbrains.annotations.Nullable;

public class EternalRitual {
    private static final Set<Point> PEDESTAL_POSITIONS = Sets.newHashSet((Object[])new Point[]{new Point(-4, -5), new Point(-4, 5), new Point(-6, 0), new Point(4, -5), new Point(4, 5), new Point(6, 0)});
    private static final Block PEDESTAL = EndBlocks.ETERNAL_PEDESTAL;
    public static final BooleanProperty ACTIVE = BlockProperties.ACTIVE;
    private Level world;
    private Direction.Axis axis;
    private ResourceLocation targetWorldId;
    private BlockPos center;
    private BlockPos exit;
    private boolean active = false;
    private boolean willActivate = false;

    public EternalRitual(Level world) {
        this.world = world;
    }

    public EternalRitual(Level world, BlockPos initial) {
        this(world);
        this.configure(initial);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    public Direction.Axis getAxis() {
        return this.axis;
    }

    public void setWorld(Level world) {
        this.world = world;
    }

    public Level getWorld() {
        return this.world;
    }

    @Nullable
    public ResourceLocation getTargetWorldId() {
        return this.targetWorldId;
    }

    private boolean isInvalid() {
        return this.world == null || this.world.m_5776_() || this.center == null || this.axis == null;
    }

    public void checkStructure(Player player) {
        Direction moveY;
        Direction moveX;
        if (this.isInvalid()) {
            return;
        }
        if (Direction.Axis.X == this.axis) {
            moveX = Direction.EAST;
            moveY = Direction.NORTH;
        } else {
            moveX = Direction.SOUTH;
            moveY = Direction.EAST;
        }
        boolean valid = this.checkFrame(this.world, this.center.m_7495_());
        Item item = null;
        for (Point pos : PEDESTAL_POSITIONS) {
            EternalPedestalEntity pedestal;
            BlockPos.MutableBlockPos checkPos = this.center.m_122032_();
            checkPos.m_122175_(moveX, pos.x).m_122175_(moveY, pos.y);
            if (!(valid &= this.isActive((BlockPos)checkPos)) || (pedestal = (EternalPedestalEntity)this.world.m_7702_((BlockPos)checkPos)) == null) continue;
            Item pItem = pedestal.m_8020_(0).m_41720_();
            if (item == null) {
                item = pItem;
                continue;
            }
            if (item.equals(pItem)) continue;
            valid = false;
        }
        if (valid && item != null) {
            this.activatePortal(player, item);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                BECriteria.PORTAL_ON.m_222618_(sp);
            }
        }
    }

    public void updateActiveStateOnPedestals() {
        if (this.world == null) {
            return;
        }
        EternalRitual.updateActiveStateOnPedestals(this.center, this.axis, this.active, this.willActivate, this.world, this);
        DataExchangeAPI.send((BaseDataHandler)new RitualUpdate(this));
    }

    public static void updateActiveStateOnPedestals(BlockPos center, Direction.Axis axis, boolean active, boolean willActivate, Level world, EternalRitual fallback) {
        Direction moveY;
        Direction moveX;
        if (Direction.Axis.X == axis) {
            moveX = Direction.EAST;
            moveY = Direction.NORTH;
        } else {
            moveX = Direction.SOUTH;
            moveY = Direction.EAST;
        }
        for (Point pos : PEDESTAL_POSITIONS) {
            BlockPos.MutableBlockPos checkPos = center.m_122032_();
            checkPos.m_122175_(moveX, pos.x).m_122175_(moveY, pos.y);
            BlockEntity blockEntity = world.m_7702_((BlockPos)checkPos);
            if (!(blockEntity instanceof EternalPedestalEntity)) continue;
            EternalPedestalEntity pedestal = (EternalPedestalEntity)blockEntity;
            if (pedestal.hasRitual()) {
                if (fallback == null) {
                    fallback = pedestal.getRitual();
                }
                pedestal.getRitual().active = active;
                pedestal.getRitual().willActivate = willActivate;
                continue;
            }
            if (fallback == null) {
                fallback = new EternalRitual(world);
                fallback.center = center;
                fallback.axis = axis;
                fallback.willActivate = willActivate;
                fallback.active = active;
            }
            pedestal.linkRitual(fallback);
        }
    }

    private boolean checkFrame(Level world, BlockPos framePos) {
        Direction moveDir = Direction.Axis.X == this.axis ? Direction.NORTH : Direction.EAST;
        boolean valid = true;
        for (Point point : PortalBuilder.FRAME_POSITIONS) {
            BlockPos.MutableBlockPos pos = framePos.m_122032_().m_122175_(moveDir, point.x).m_122175_(Direction.UP, point.y);
            BlockState state = world.m_8055_((BlockPos)pos);
            valid &= state.m_60734_() instanceof RunedFlavolite;
            pos = framePos.m_122032_().m_122175_(moveDir, -point.x).m_122175_(Direction.UP, point.y);
            state = world.m_8055_((BlockPos)pos);
            valid &= state.m_60734_() instanceof RunedFlavolite;
        }
        return valid;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean willActivate() {
        return this.willActivate;
    }

    private void activatePortal(Player player, Item keyItem) {
        if (this.active) {
            return;
        }
        this.willActivate = true;
        this.updateActiveStateOnPedestals();
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)keyItem);
        int portalId = EndPortals.getPortalIdByItem(itemId);
        Level targetWorld = this.getTargetWorld(portalId);
        ResourceLocation worldId = targetWorld.m_46472_().m_135782_();
        try {
            if (this.exit == null) {
                this.initPortal(player, worldId, portalId);
            } else {
                if (!worldId.equals((Object)this.targetWorldId)) {
                    this.initPortal(player, worldId, portalId);
                } else if (!this.checkFrame(targetWorld, this.exit.m_7495_())) {
                    Direction.Axis portalAxis = Direction.Axis.X == this.axis ? Direction.Axis.Z : Direction.Axis.X;
                    PortalBuilder.generatePortal(targetWorld, this.exit, portalAxis, portalId);
                }
                this.activatePortal(targetWorld, this.exit, portalId);
            }
            this.activatePortal(this.world, this.center, portalId);
            Level level = this.world;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.doEffects(serverLevel, this.center);
            }
            this.willActivate = false;
            this.active = true;
            this.updateActiveStateOnPedestals();
        }
        catch (Exception ex) {
            BetterEnd.LOGGER.error("Create End portals error.", ex);
            this.removePortal(targetWorld, this.exit);
            this.removePortal(this.world, this.center);
            this.willActivate = false;
            this.active = false;
            this.updateActiveStateOnPedestals();
        }
    }

    private void initPortal(Player player, ResourceLocation worldId, int portalId) {
        this.targetWorldId = worldId;
        Level level = this.world;
        if (level instanceof ServerLevel) {
            WorldBorder worldBorder;
            ServerLevel sourceWorld = (ServerLevel)level;
            ServerLevel targetLevel = (ServerLevel)this.getTargetWorld(portalId);
            PortalBuilder builder = new PortalBuilder(this.world, targetLevel);
            Optional<BlockUtil.FoundRectangle> foundRectangle = builder.findPortalAround(this.center, worldBorder = targetLevel.m_6857_());
            if (!foundRectangle.isPresent()) {
                Optional<BlockPos> centerPos = builder.createPortal(PortalBuilder.getStartingPos((Level)sourceWorld, (Level)targetLevel, (Entity)player, worldBorder), this.axis, portalId);
                centerPos.ifPresent(blockPos -> {
                    this.exit = blockPos;
                });
            }
        }
    }

    private void doEffects(ServerLevel serverWorld, BlockPos center) {
        Direction moveY;
        Direction moveX;
        if (Direction.Axis.X == this.axis) {
            moveX = Direction.EAST;
            moveY = Direction.NORTH;
        } else {
            moveX = Direction.SOUTH;
            moveY = Direction.EAST;
        }
        for (Point pos : PEDESTAL_POSITIONS) {
            BlockPos.MutableBlockPos p = center.m_122032_();
            p.m_122175_(moveX, pos.x).m_122175_(moveY, pos.y);
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 1.5, (double)p.m_123343_() + 0.5, 20, 0.0, 0.0, 0.0, 1.0);
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123789_, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 1.5, (double)p.m_123343_() + 0.5, 20, 0.0, 0.0, 0.0, 0.3);
        }
        serverWorld.m_5594_(null, center, SoundEvents.f_11860_, SoundSource.NEUTRAL, 16.0f, 1.0f);
    }

    private void activatePortal(Level world, BlockPos center, int portalId) {
        BlockPos framePos = center.m_7495_();
        Direction moveDir = Direction.Axis.X == this.axis ? Direction.NORTH : Direction.EAST;
        BlockState frame = (BlockState)PortalBuilder.FRAME.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true));
        PortalBuilder.FRAME_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = framePos.m_122032_().m_122175_(moveDir, point.x).m_122175_(Direction.UP, point.y);
            BlockState state = world.m_8055_((BlockPos)pos);
            if (state.m_61138_((Property)ACTIVE) && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                world.m_46597_((BlockPos)pos, frame);
            }
            if ((state = world.m_8055_((BlockPos)(pos = framePos.m_122032_().m_122175_(moveDir, -point.x).m_122175_(Direction.UP, point.y)))).m_61138_((Property)ACTIVE) && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                world.m_46597_((BlockPos)pos, frame);
            }
        });
        Direction.Axis portalAxis = Direction.Axis.X == this.axis ? Direction.Axis.Z : Direction.Axis.X;
        BlockState portal = (BlockState)((BlockState)PortalBuilder.PORTAL.m_49966_().m_61124_((Property)EndPortalBlock.f_54904_, (Comparable)portalAxis)).m_61124_((Property)EndPortalBlock.PORTAL, (Comparable)Integer.valueOf(portalId));
        BlockParticleOption effect = new BlockParticleOption(ParticleTypes.f_123794_, portal);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            PortalBuilder.PORTAL_POSITIONS.forEach(arg_0 -> EternalRitual.lambda$activatePortal$2(center, moveDir, world, portal, serverWorld, (ParticleOptions)effect, arg_0));
        }
    }

    public void disablePortal(int state) {
        if (!this.active || this.isInvalid()) {
            return;
        }
        if (!this.world.m_5776_()) {
            this.removePortal(this.getTargetWorld(state), this.exit);
        }
        this.removePortal(this.world, this.center);
    }

    private void removePortal(Level world, BlockPos center) {
        BlockPos framePos = center.m_7495_();
        Direction moveDir = Direction.Axis.X == this.axis ? Direction.NORTH : Direction.EAST;
        PortalBuilder.FRAME_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = framePos.m_122032_().m_122175_(moveDir, point.x).m_122175_(Direction.UP, point.y);
            BlockState state = world.m_8055_((BlockPos)pos);
            if (state.m_60713_(PortalBuilder.FRAME) && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                world.m_46597_((BlockPos)pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
            if ((state = world.m_8055_((BlockPos)(pos = framePos.m_122032_().m_122175_(moveDir, -point.x).m_122175_(Direction.UP, point.y)))).m_60713_(PortalBuilder.FRAME) && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                world.m_46597_((BlockPos)pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        });
        PortalBuilder.PORTAL_POSITIONS.forEach(point -> {
            BlockPos.MutableBlockPos pos = center.m_122032_().m_122175_(moveDir, point.x).m_122175_(Direction.UP, point.y);
            if (world.m_8055_((BlockPos)pos).m_60713_(PortalBuilder.PORTAL)) {
                world.m_7471_((BlockPos)pos, false);
            }
            if (world.m_8055_((BlockPos)(pos = center.m_122032_().m_122175_(moveDir, -point.x).m_122175_(Direction.UP, point.y))).m_60713_(PortalBuilder.PORTAL)) {
                world.m_7471_((BlockPos)pos, false);
            }
        });
        this.active = false;
        this.updateActiveStateOnPedestals();
    }

    private Level getTargetWorld(int state) {
        if (this.world.m_46472_() == Level.f_46430_) {
            return EndPortals.getWorld(this.world.m_7654_(), state);
        }
        return Objects.requireNonNull(this.world.m_7654_()).m_129880_(Level.f_46430_);
    }

    public void configure(BlockPos initial) {
        BlockPos checkPos = initial.m_122030_(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = initial.m_122030_(6);
            return;
        }
        checkPos = initial.m_122025_(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = initial.m_122025_(6);
            return;
        }
        checkPos = initial.m_122020_(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = initial.m_122020_(6);
            return;
        }
        checkPos = initial.m_122013_(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = initial.m_122013_(6);
            return;
        }
        checkPos = initial.m_122013_(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = this.hasPedestal(checkPos = checkPos.m_122030_(8)) ? initial.m_122013_(5).m_122030_(4) : initial.m_122013_(5).m_122025_(4);
            return;
        }
        checkPos = initial.m_122020_(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.X;
            this.center = this.hasPedestal(checkPos = checkPos.m_122030_(8)) ? initial.m_122020_(5).m_122030_(4) : initial.m_122020_(5).m_122025_(4);
            return;
        }
        checkPos = initial.m_122030_(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = this.hasPedestal(checkPos = checkPos.m_122020_(8)) ? initial.m_122030_(5).m_122020_(4) : initial.m_122030_(5).m_122013_(4);
            return;
        }
        checkPos = initial.m_122025_(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = Direction.Axis.Z;
            this.center = this.hasPedestal(checkPos = checkPos.m_122020_(8)) ? initial.m_122025_(5).m_122020_(4) : initial.m_122025_(5).m_122013_(4);
        }
    }

    private boolean hasPedestal(BlockPos pos) {
        return this.world.m_8055_(pos).m_60713_(PEDESTAL);
    }

    private boolean isActive(BlockPos pos) {
        BlockState state = this.world.m_8055_(pos);
        if (state.m_60713_(PEDESTAL)) {
            EternalPedestalEntity pedestal = (EternalPedestalEntity)this.world.m_7702_(pos);
            if (pedestal != null) {
                if (!pedestal.hasRitual()) {
                    pedestal.linkRitual(this);
                } else {
                    EternalRitual ritual = pedestal.getRitual();
                    if (!ritual.equals(this)) {
                        pedestal.linkRitual(this);
                    }
                }
            }
            return (Boolean)state.m_61143_((Property)ACTIVE);
        }
        return false;
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (this.center == null || this.axis == null || this.exit == null) {
            return null;
        }
        tag.m_128365_("center", (Tag)NbtUtils.m_129224_((BlockPos)this.center));
        tag.m_128359_("axis", this.axis.m_122477_());
        tag.m_128379_("active", this.active);
        if (this.targetWorldId != null) {
            tag.m_128359_("key_item", this.targetWorldId.toString());
        }
        if (this.exit != null) {
            tag.m_128365_("exit", (Tag)NbtUtils.m_129224_((BlockPos)this.exit));
        }
        return tag;
    }

    public void fromTag(CompoundTag tag) {
        this.axis = Direction.Axis.m_122473_((String)tag.m_128461_("axis"));
        this.center = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("center"));
        this.active = tag.m_128471_("active");
        if (tag.m_128441_("exit")) {
            this.exit = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("exit"));
        }
        if (tag.m_128441_("key_item")) {
            this.targetWorldId = new ResourceLocation(tag.m_128461_("key_item"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EternalRitual ritual = (EternalRitual)o;
        return this.world.equals(ritual.world) && Objects.equals(this.center, ritual.center) && Objects.equals(this.exit, ritual.exit);
    }

    public static EternalRitual findRitualForActivePortal(Level world, BlockPos startPos) {
        BlockState state = world.m_8055_(startPos);
        if (EternalRitual.isActivePortalBlock(state)) {
            BlockEntity blockEntity;
            Direction direction;
            Direction direction2 = direction = state.m_61143_((Property)NetherPortalBlock.f_54904_) == Direction.Axis.X ? Direction.EAST : Direction.NORTH;
            while (world.m_8055_(startPos.m_7495_()).m_60713_(EndBlocks.END_PORTAL_BLOCK)) {
                startPos = startPos.m_7495_();
            }
            if (world.m_8055_(startPos.m_5484_(direction, -1)).m_60713_(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.m_5484_(direction, 1);
            } else if (world.m_8055_(startPos.m_5484_(direction, 1)).m_60713_(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.m_5484_(direction, -1);
            }
            if (!world.m_8055_(startPos.m_7495_()).m_60713_(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.m_7495_();
            }
            if (world.m_8055_(startPos.m_5484_(direction, -1)).m_60713_(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.m_5484_(direction, 1);
            } else if (world.m_8055_(startPos.m_5484_(direction, 1)).m_60713_(EndBlocks.FLAVOLITE_RUNED_ETERNAL)) {
                startPos = startPos.m_5484_(direction, -1);
            }
            startPos = startPos.m_5484_(direction.m_122427_(), 6);
            state = world.m_8055_(startPos);
            if (state.m_60713_(EndBlocks.ETERNAL_PEDESTAL) && (blockEntity = world.m_7702_(startPos)) instanceof EternalPedestalEntity) {
                EternalPedestalEntity pedestal = (EternalPedestalEntity)blockEntity;
                return pedestal.getRitual();
            }
            return null;
        }
        return null;
    }

    private static boolean isActivePortalBlock(BlockState state) {
        return state.m_60713_(EndBlocks.END_PORTAL_BLOCK) && state.m_61138_((Property)NetherPortalBlock.f_54904_);
    }

    private static /* synthetic */ void lambda$activatePortal$2(BlockPos center, Direction moveDir, Level world, BlockState portal, ServerLevel serverWorld, ParticleOptions effect, Point point) {
        BlockPos.MutableBlockPos pos = center.m_122032_().m_122175_(moveDir, point.x).m_122175_(Direction.UP, point.y);
        if (!world.m_8055_((BlockPos)pos).m_60713_(PortalBuilder.PORTAL)) {
            world.m_46597_((BlockPos)pos, portal);
            serverWorld.m_8767_(effect, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123789_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
        if (!world.m_8055_((BlockPos)(pos = center.m_122032_().m_122175_(moveDir, -point.x).m_122175_(Direction.UP, point.y))).m_60713_(PortalBuilder.PORTAL)) {
            world.m_46597_((BlockPos)pos, portal);
            serverWorld.m_8767_(effect, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123789_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
    }
}

