/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.item.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.bclib.util.MHelper;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.CommonItemTags;

public class EndHammerItem
extends DiggerItem
implements ItemModelProvider,
TagProvider {
    public static final UUID ATTACK_KNOCKBACK_MODIFIER_ID = Mth.m_216261_((RandomSource)MHelper.RANDOM_SOURCE);
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;

    public EndHammerItem(Tier material, float attackDamage, float attackSpeed, double knockback, Item.Properties settings) {
        super(attackDamage, attackSpeed, material, CommonBlockTags.MINABLE_WITH_HAMMER, settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(attackDamage + material.m_6631_()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER_ID, "Weapon modifier", knockback, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player miner) {
        return state.m_204336_(CommonBlockTags.MINABLE_WITH_HAMMER) || state.m_60713_(Blocks.f_50090_) || state.m_60713_(Blocks.f_50268_) || state.m_60713_(Blocks.f_50060_) || state.m_60713_(Blocks.f_50330_);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            stack.m_41622_(1, miner, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_280603_() == NoteBlockInstrument.HAT) {
            return this.m_43314_().m_6624_() * 2.0f;
        }
        if (this.m_8096_(state)) {
            float mult = state.m_60713_(Blocks.f_50090_) || state.m_60713_(Blocks.f_50268_) || state.m_60713_(Blocks.f_50060_) || state.m_60713_(Blocks.f_50330_) ? this.m_43314_().m_6624_() : this.m_43314_().m_6624_() / 2.0f;
            return Math.max(mult, 1.0f);
        }
        return 1.0f;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(slot);
    }

    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return ModelsHelper.createHandheldItem((ResourceLocation)resourceLocation);
    }

    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        itemTags.add((TagKey<Item>)CommonItemTags.HAMMERS);
    }
}

