/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.entity.EndSlimeEntity;
import org.betterx.betterend.registry.EndEntitiesRenders;

public class EndSlimeEntityModel<T extends EndSlimeEntity>
extends ListModel<T> {
    private final ModelPart innerCube;
    private final ModelPart rightEye;
    private final ModelPart leftEye;
    private final ModelPart mouth;
    private final ModelPart flower;
    private final ModelPart crop;

    public static LayerDefinition getShellOnlyTexturedModelData() {
        return EndSlimeEntityModel.getTexturedModelData(true);
    }

    public static LayerDefinition getCompleteTexturedModelData() {
        return EndSlimeEntityModel.getTexturedModelData(false);
    }

    private static LayerDefinition getTexturedModelData(boolean onlyShell) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        if (onlyShell) {
            modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, 16.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        } else {
            modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-3.0f, 17.0f, -3.0f, 6.0f, 6.0f, 6.0f), PartPose.f_171404_);
            modelPartData.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-3.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.f_171404_);
            modelPartData.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(32, 4).m_171481_(1.25f, 18.0f, -3.5f, 2.0f, 2.0f, 2.0f), PartPose.f_171404_);
            modelPartData.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(32, 8).m_171481_(0.0f, 21.0f, -3.5f, 1.0f, 1.0f, 1.0f), PartPose.f_171404_);
            PartDefinition flowerPart = modelPartData.m_171599_("flower", CubeListBuilder.m_171558_(), PartPose.f_171404_);
            PartDefinition cropPart = modelPartData.m_171599_("crop", CubeListBuilder.m_171558_(), PartPose.f_171404_);
            for (int i = 0; i < 6; ++i) {
                PartDefinition parent = i < 4 ? flowerPart : cropPart;
                float rot = MHelper.degreesToRadians((float)(i < 4 ? (float)i * 45.0f : (float)(i - 4) * 90.0f + 45.0f));
                PartDefinition petalRotPart = parent.m_171599_("petalRot_" + i, CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)rot, (float)0.0f));
                petalRotPart.m_171599_("petal_" + i, CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 0.0f), PartPose.m_171419_((float)-4.0f, (float)8.0f, (float)0.0f));
            }
        }
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)32);
    }

    public EndSlimeEntityModel(EntityModelSet modelSet, boolean onlyShell) {
        super(RenderType::m_110452_);
        ModelPart modelPart = modelSet.m_171103_(onlyShell ? EndEntitiesRenders.END_SLIME_SHELL_MODEL : EndEntitiesRenders.END_SLIME_MODEL);
        this.innerCube = modelPart.m_171324_("body");
        if (!onlyShell) {
            this.rightEye = modelPart.m_171324_("right_eye");
            this.leftEye = modelPart.m_171324_("left_eye");
            this.mouth = modelPart.m_171324_("mouth");
            this.flower = modelPart.m_171324_("flower");
            this.crop = modelPart.m_171324_("crop");
        } else {
            this.rightEye = null;
            this.leftEye = null;
            this.mouth = null;
            this.flower = null;
            this.crop = null;
        }
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
    }

    public void renderFlower(PoseStack matrices, VertexConsumer vertices, int light, int overlay) {
        this.flower.m_104301_(matrices, vertices, light, overlay);
    }

    public void renderCrop(PoseStack matrices, VertexConsumer vertices, int light, int overlay) {
        this.crop.m_104301_(matrices, vertices, light, overlay);
    }

    private boolean isOnlyShell() {
        return this.rightEye == null;
    }

    public Iterable<ModelPart> m_6195_() {
        if (this.isOnlyShell()) {
            return ImmutableList.of((Object)this.innerCube);
        }
        return ImmutableList.of((Object)this.innerCube, (Object)this.rightEye, (Object)this.leftEye, (Object)this.mouth);
    }
}

