/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.entity;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.interfaces.ISlime;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.util.GlobalState;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class EndSlimeEntity
extends Slime {
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(EndSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public EndSlimeEntity(EntityType<EndSlimeEntity> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new EndSlimeMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SwimmingGoal());
        this.f_21345_.m_25352_(2, (Goal)new FaceTowardTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new RandomLookGoal());
        this.f_21345_.m_25352_(5, (Goal)new MoveGoal());
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> Math.abs(livingEntity.m_20186_() - this.m_20186_()) <= 4.0));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData, CompoundTag entityTag) {
        SpawnGroupData data = super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
        BCLBiome biome = BiomeAPI.getBiome((Holder)world.m_204166_(this.m_20183_()));
        if (!BCLBiomeRegistry.isEmptyBiome((BCLBiome)biome)) {
            if (biome.equals(EndBiomes.FOGGY_MUSHROOMLAND)) {
                this.setMossy();
            } else if (biome.equals(EndBiomes.MEGALAKE) || biome.equals(EndBiomes.MEGALAKE_GROVE)) {
                this.setLake();
            } else if (biome.equals(EndBiomes.AMBER_LAND)) {
                this.setAmber();
            }
            this.m_6210_();
        }
        return data;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Variant", (byte)this.getSlimeType());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.f_19804_.m_135381_(VARIANT, (Object)tag.m_128445_("Variant"));
        }
    }

    protected ParticleOptions m_6300_() {
        return ParticleTypes.f_123760_;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        int i = this.m_33632_();
        if (!this.m_9236_().f_46443_ && i > 1 && this.m_21224_()) {
            Component text = this.m_7770_();
            boolean bl = this.m_21525_();
            float f = (float)i / 4.0f;
            int j = i / 2;
            int k = 2 + this.f_19796_.m_188503_(3);
            int type = this.getSlimeType();
            for (int l = 0; l < k; ++l) {
                float g = ((float)(l % 2) - 0.5f) * f;
                float h = ((float)(l / 2) - 0.5f) * f;
                EndSlimeEntity slimeEntity = (EndSlimeEntity)this.m_6095_().m_20615_(this.m_9236_());
                if (this.m_21532_()) {
                    slimeEntity.m_21530_();
                }
                slimeEntity.setSlimeType(type);
                slimeEntity.m_6593_(text);
                slimeEntity.m_21557_(bl);
                slimeEntity.m_20331_(this.m_20147_());
                ((ISlime)((Object)slimeEntity)).be_setSlimeSize(j, true);
                slimeEntity.m_6210_();
                slimeEntity.m_7678_(this.m_20185_() + (double)g, this.m_20186_() + 0.5, this.m_20189_() + (double)h, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)slimeEntity);
            }
        }
        ((ISlime)((Object)this)).entityRemove(reason);
    }

    protected void m_7625_(DamageSource source, boolean causedByPlayer) {
        int maxCount = this.m_33632_();
        int minCount = maxCount >> 1;
        if (minCount < 1) {
            minCount = 1;
        }
        if (causedByPlayer && this.f_20888_ != null) {
            int looting = EnchantmentHelper.m_44930_((LivingEntity)this.f_20888_);
            minCount += looting;
        }
        int count = minCount < maxCount ? MHelper.randRange((int)minCount, (int)maxCount, (RandomSource)this.f_19796_) : maxCount;
        ItemEntity drop = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42518_, count));
        this.m_9236_().m_7967_((Entity)drop);
    }

    public int getSlimeType() {
        return ((Byte)this.f_19804_.m_135370_(VARIANT)).intValue();
    }

    public void setSlimeType(int value) {
        this.f_19804_.m_135381_(VARIANT, (Object)((byte)value));
    }

    protected void setMossy() {
        this.setSlimeType(1);
    }

    public boolean isMossy() {
        return this.getSlimeType() == 1;
    }

    protected void setLake() {
        this.setSlimeType(2);
    }

    public boolean isLake() {
        return this.getSlimeType() == 2;
    }

    protected void setAmber() {
        this.f_19804_.m_135381_(VARIANT, (Object)3);
    }

    public boolean isAmber() {
        return (Byte)this.f_19804_.m_135370_(VARIANT) == 3;
    }

    public boolean isChorus() {
        return (Byte)this.f_19804_.m_135370_(VARIANT) == 0;
    }

    public static boolean canSpawn(EntityType entityType, LevelAccessor world, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!world.m_8055_(pos.m_7495_()).m_204336_(CommonBlockTags.END_STONES)) {
            return false;
        }
        BCLBiome biome = BiomeAPI.getBiome((Holder)world.m_204166_(pos));
        if (!BCLBiomeRegistry.isEmptyBiome((BCLBiome)biome)) {
            if (biome.equals(EndBiomes.CHORUS_FOREST) || biome.equals(EndBiomes.MEGALAKE)) {
                return true;
            }
            if (biome.equals(EndBiomes.MEGALAKE_GROVE) && random.m_188499_()) {
                return true;
            }
        }
        return random.m_188503_(4) == 0 && EndSlimeEntity.isWaterNear(world, pos);
    }

    private static boolean isWaterNear(LevelAccessor world, BlockPos pos) {
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        for (int x = pos.m_123341_() - 32; x <= pos.m_123341_() + 32; ++x) {
            POS.m_142451_(x);
            for (int z = pos.m_123343_() - 32; z <= pos.m_123343_() + 32; ++z) {
                POS.m_142443_(z);
                for (int y = pos.m_123342_() - 8; y <= pos.m_123342_() + 8; ++y) {
                    POS.m_142448_(y);
                    if (world.m_8055_((BlockPos)POS).m_60734_() != Blocks.f_49990_) continue;
                    return true;
                }
            }
        }
        return false;
    }

    class EndSlimeMoveControl
    extends MoveControl {
        private float targetYaw;
        private int ticksUntilJump;
        private boolean jumpOften;

        public EndSlimeMoveControl(EndSlimeEntity slime) {
            super((Mob)slime);
            this.targetYaw = 180.0f * slime.m_146908_() / (float)Math.PI;
        }

        public void look(float targetYaw, boolean jumpOften) {
            this.targetYaw = targetYaw;
            this.jumpOften = jumpOften;
        }

        public void move(double speed) {
            this.f_24978_ = speed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void m_8126_() {
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), this.targetYaw, 90.0f));
            this.f_24974_.f_20885_ = this.f_24974_.m_146908_();
            this.f_24974_.f_20883_ = this.f_24974_.m_146908_();
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.f_24974_.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.f_24974_.m_20096_()) {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                    if (this.ticksUntilJump-- <= 0) {
                        this.ticksUntilJump = EndSlimeEntity.this.m_7549_();
                        if (this.jumpOften) {
                            this.ticksUntilJump /= 3;
                        }
                        EndSlimeEntity.this.m_21569_().m_24901_();
                        if (EndSlimeEntity.this.m_33634_()) {
                            EndSlimeEntity.this.m_5496_(EndSlimeEntity.this.m_7903_(), EndSlimeEntity.this.m_6121_(), this.getJumpSoundPitch());
                        }
                    } else {
                        EndSlimeEntity.this.f_20900_ = 0.0f;
                        EndSlimeEntity.this.f_20902_ = 0.0f;
                        this.f_24974_.m_7910_(0.0f);
                    }
                } else {
                    this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
                }
            }
        }

        private float getJumpSoundPitch() {
            float f = EndSlimeEntity.this.m_33633_() ? 1.4f : 0.8f;
            return ((EndSlimeEntity.this.f_19796_.m_188501_() - EndSlimeEntity.this.f_19796_.m_188501_()) * 0.2f + 1.0f) * f;
        }
    }

    class SwimmingGoal
    extends Goal {
        public SwimmingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            EndSlimeEntity.this.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return (EndSlimeEntity.this.m_20069_() || EndSlimeEntity.this.m_20077_()) && EndSlimeEntity.this.m_21566_() instanceof EndSlimeMoveControl;
        }

        public void m_8037_() {
            if (EndSlimeEntity.this.m_217043_().m_188501_() < 0.8f) {
                EndSlimeEntity.this.m_21569_().m_24901_();
            }
            ((EndSlimeMoveControl)EndSlimeEntity.this.m_21566_()).move(1.2);
        }
    }

    class FaceTowardTargetGoal
    extends Goal {
        private int ticksLeft;

        public FaceTowardTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = EndSlimeEntity.this.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            return (!(livingEntity instanceof Player) || !((Player)livingEntity).m_150110_().f_35934_) && EndSlimeEntity.this.m_21566_() instanceof EndSlimeMoveControl;
        }

        public void m_8056_() {
            this.ticksLeft = 300;
            super.m_8056_();
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = EndSlimeEntity.this.m_5448_();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.m_6084_()) {
                return false;
            }
            if (livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35934_) {
                return false;
            }
            return --this.ticksLeft > 0;
        }

        public void m_8037_() {
            EndSlimeEntity.this.m_21391_((Entity)EndSlimeEntity.this.m_5448_(), 10.0f, 10.0f);
            ((EndSlimeMoveControl)EndSlimeEntity.this.m_21566_()).look(EndSlimeEntity.this.m_146908_(), EndSlimeEntity.this.m_7483_());
        }
    }

    class RandomLookGoal
    extends Goal {
        private float targetYaw;
        private int timer;

        public RandomLookGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return EndSlimeEntity.this.m_5448_() == null && (EndSlimeEntity.this.m_20096_() || EndSlimeEntity.this.m_20069_() || EndSlimeEntity.this.m_20077_() || EndSlimeEntity.this.m_21023_(MobEffects.f_19620_)) && EndSlimeEntity.this.m_21566_() instanceof EndSlimeMoveControl;
        }

        public void m_8037_() {
            if (--this.timer <= 0) {
                this.timer = 40 + EndSlimeEntity.this.m_217043_().m_188503_(60);
                this.targetYaw = EndSlimeEntity.this.m_217043_().m_188503_(360);
            }
            ((EndSlimeMoveControl)EndSlimeEntity.this.m_21566_()).look(this.targetYaw, false);
        }
    }

    class MoveGoal
    extends Goal {
        public MoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (EndSlimeEntity.this.m_20159_()) {
                return false;
            }
            float yaw = EndSlimeEntity.this.m_6080_();
            float speed = EndSlimeEntity.this.m_6113_();
            if ((double)speed > 0.1) {
                float dx = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180)));
                float dz = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180)));
                BlockPos pos = EndSlimeEntity.this.m_20183_().m_7918_((int)(dx * speed * 4.0f), 0, (int)(dz * speed * 4.0f));
                int down = BlocksHelper.downRay((LevelAccessor)EndSlimeEntity.this.m_9236_(), (BlockPos)pos, (int)16);
                return down < 5;
            }
            return true;
        }

        public void m_8037_() {
            ((EndSlimeMoveControl)EndSlimeEntity.this.m_21566_()).move(1.0);
        }
    }
}

