/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.client.ClientOptions;
import org.betterx.betterend.client.render.BetterEndSkyRenderer;
import org.betterx.betterend.events.ItemTooltipCallback;
import org.betterx.betterend.integration.trinkets.ElytraClient;
import org.betterx.betterend.interfaces.MultiModelItem;
import org.betterx.betterend.item.CrystaliteArmor;
import org.betterx.betterend.registry.EndBlockEntityRenders;
import org.betterx.betterend.registry.EndEntitiesRenders;
import org.betterx.betterend.registry.EndModelProviders;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.registry.EndScreens;
import org.betterx.betterend.world.generator.GeneratorOptions;

public class BetterEndClient
implements ClientModInitializer {
    public void onInitializeClient() {
        EndBlockEntityRenders.register();
        EndScreens.register();
        EndParticles.register();
        EndEntitiesRenders.register();
        EndModelProviders.register();
        MultiModelItem.register();
        ClientOptions.init();
        BetterEndClient.registerTooltips();
        ResourceLocation checkFlowerId = new ResourceLocation("item/chorus_flower");
        ResourceLocation checkPlantId = new ResourceLocation("item/chorus_plant");
        ResourceLocation toLoadFlowerId = new ResourceLocation("betterend", "item/custom_chorus_flower");
        ResourceLocation toLoadPlantId = new ResourceLocation("betterend", "item/custom_chorus_plant");
        ModelLoadingRegistry.INSTANCE.registerResourceProvider(manager -> (resourceId, context) -> {
            if (GeneratorOptions.changeChorusPlant()) {
                if (resourceId.equals((Object)checkFlowerId)) {
                    return context.loadModel(toLoadFlowerId);
                }
                if (resourceId.equals((Object)checkPlantId)) {
                    return context.loadModel(toLoadPlantId);
                }
            }
            return null;
        });
        if (ClientOptions.isCustomSky()) {
            DimensionRenderingRegistry.registerSkyRenderer((ResourceKey)Level.f_46430_, (DimensionRenderingRegistry.SkyRenderer)new BetterEndSkyRenderer());
        }
        if (BetterEnd.RUNS_TRINKETS) {
            ElytraClient.register();
        }
    }

    public static void registerTooltips() {
        ItemTooltipCallback.EVENT.register((player, stack, context, lines) -> {
            if (stack.m_41720_() instanceof CrystaliteArmor) {
                boolean hasSet = false;
                if (player != null) {
                    hasSet = CrystaliteArmor.hasFullSet((LivingEntity)player);
                }
                MutableComponent setDesc = Component.m_237115_((String)"tooltip.armor.crystalite_set");
                setDesc.m_6270_(Style.f_131099_.m_131152_(new ChatFormatting[]{hasSet ? ChatFormatting.BLUE : ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                lines.add(Component.m_237119_());
                lines.add(setDesc);
            }
        });
    }
}

