/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks.basis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.interfaces.TagProvider;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.InfusionPedestal;
import org.betterx.betterend.blocks.entities.InfusionPedestalEntity;
import org.betterx.betterend.blocks.entities.PedestalBlockEntity;
import org.betterx.betterend.client.models.Patterns;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.rituals.InfusionRitual;
import org.jetbrains.annotations.Nullable;

public class PedestalBlock
extends BaseBlockNotFull
implements EntityBlock,
TagProvider {
    public static final EnumProperty<EndBlockProperties.PedestalState> STATE = EndBlockProperties.PEDESTAL_STATE;
    public static final BooleanProperty HAS_ITEM = EndBlockProperties.HAS_ITEM;
    public static final BooleanProperty HAS_LIGHT = BlockProperties.HAS_LIGHT;
    private static final VoxelShape SHAPE_DEFAULT;
    private static final VoxelShape SHAPE_COLUMN;
    private static final VoxelShape SHAPE_PILLAR;
    private static final VoxelShape SHAPE_PEDESTAL_TOP;
    private static final VoxelShape SHAPE_COLUMN_TOP;
    private static final VoxelShape SHAPE_BOTTOM;
    protected final Block parent;
    protected float height = 1.0f;

    public PedestalBlock(Block parent) {
        super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)parent).luminance(PedestalBlock.getLuminance(parent.m_49966_())));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.DEFAULT))).m_61124_((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(false)));
        this.parent = parent;
    }

    private static ToIntFunction<BlockState> getLuminance(BlockState parent) {
        int light = parent.m_60791_();
        if (light > 0) {
            return state -> light;
        }
        return state -> (Boolean)state.m_61143_((Property)HAS_LIGHT) != false ? 12 : 0;
    }

    public float getHeight(BlockState state) {
        if (state.m_60734_() instanceof PedestalBlock && state.m_61143_(STATE) == EndBlockProperties.PedestalState.PEDESTAL_TOP) {
            return this.height - 0.2f;
        }
        return this.height;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!state.m_60713_((Block)this) || !this.isPlaceable(state)) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
            if (pedestal.m_7983_()) {
                ItemStack itemStack = player.m_21120_(hand);
                if (itemStack.m_41619_()) {
                    return InteractionResult.CONSUME;
                }
                pedestal.m_6836_(0, itemStack);
                level.m_151543_(pos);
                this.checkRitual(level, player, pos);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            ItemStack itemStack = pedestal.m_8020_(0);
            if (player.m_36356_(itemStack)) {
                pedestal.m_8016_(0);
                level.m_151543_(pos);
                this.checkRitual(level, player, pos);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void m_6786_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (Point point : InfusionRitual.getMap()) {
            InfusionPedestalEntity pedestal;
            posMutable.m_122190_((Vec3i)blockPos).m_122184_(point.x, 0, point.y);
            BlockState state = levelAccessor.m_8055_((BlockPos)posMutable);
            if (!(state.m_60734_() instanceof InfusionPedestal)) continue;
            BlockEntity blockEntity = levelAccessor.m_7702_((BlockPos)posMutable);
            if (!(blockEntity instanceof InfusionPedestalEntity) || !(pedestal = (InfusionPedestalEntity)blockEntity).hasRitual()) break;
            pedestal.getRitual().setDirty();
            break;
        }
    }

    public void checkRitual(Level world, Player player, BlockPos pos) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (Point point : InfusionRitual.getMap()) {
            posMutable.m_122190_((Vec3i)pos).m_122184_(point.x, 0, point.y);
            BlockState state = world.m_8055_((BlockPos)posMutable);
            if (!(state.m_60734_() instanceof InfusionPedestal)) continue;
            ((InfusionPedestal)state.m_60734_()).checkRitual(world, player, (BlockPos)posMutable);
            break;
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState upState = world.m_8055_(pos.m_7494_());
        BlockState downState = world.m_8055_(pos.m_7495_());
        boolean upSideSolid = upState.m_60783_((BlockGetter)world, pos.m_7494_(), Direction.DOWN) || upState.m_204336_(BlockTags.f_13032_);
        boolean hasPedestalOver = upState.m_60734_() instanceof PedestalBlock;
        boolean hasPedestalUnder = downState.m_60734_() instanceof PedestalBlock;
        if (!hasPedestalOver && hasPedestalUnder && upSideSolid) {
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN_TOP));
        }
        if (!hasPedestalOver && !hasPedestalUnder && upSideSolid) {
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN));
        }
        if (hasPedestalUnder && hasPedestalOver) {
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PILLAR));
        }
        if (hasPedestalUnder) {
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PEDESTAL_TOP));
        }
        if (hasPedestalOver) {
            return (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.BOTTOM));
        }
        return this.m_49966_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        BlockState updated = this.getUpdatedState(state, direction, newState, world, pos, posFrom);
        if (!updated.m_60713_((Block)this)) {
            return updated;
        }
        if (!this.isPlaceable(updated)) {
            this.moveStoredStack(world, updated, pos);
        }
        return updated;
    }

    private BlockState getUpdatedState(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (!state.m_60713_((Block)this)) {
            return state.m_60728_(direction, newState, world, pos, posFrom);
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        BlockState upState = world.m_8055_(pos.m_7494_());
        BlockState downState = world.m_8055_(pos.m_7495_());
        boolean upSideSolid = upState.m_60783_((BlockGetter)world, pos.m_7494_(), Direction.DOWN) || upState.m_204336_(BlockTags.f_13032_);
        boolean hasPedestalOver = upState.m_60734_() instanceof PedestalBlock;
        boolean hasPedestalUnder = downState.m_60734_() instanceof PedestalBlock;
        if (direction == Direction.UP) {
            upSideSolid = newState.m_60783_((BlockGetter)world, posFrom, Direction.DOWN) || newState.m_204336_(BlockTags.f_13032_);
            hasPedestalOver = newState.m_60734_() instanceof PedestalBlock;
        } else {
            hasPedestalUnder = newState.m_60734_() instanceof PedestalBlock;
        }
        BlockState updatedState = !hasPedestalOver && hasPedestalUnder && upSideSolid ? (BlockState)state.m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN_TOP)) : (!hasPedestalOver && !hasPedestalUnder && upSideSolid ? (BlockState)state.m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.COLUMN)) : (hasPedestalUnder && hasPedestalOver ? (BlockState)state.m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PILLAR)) : (hasPedestalUnder ? (BlockState)state.m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.PEDESTAL_TOP)) : (hasPedestalOver ? (BlockState)state.m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.BOTTOM)) : (BlockState)state.m_61124_(STATE, (Comparable)((Object)EndBlockProperties.PedestalState.DEFAULT))))));
        if (!this.isPlaceable(updatedState)) {
            updatedState = (BlockState)((BlockState)updatedState.m_61124_((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HAS_LIGHT, (Comparable)Boolean.valueOf(false));
        }
        return updatedState;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ArrayList drop = Lists.newArrayList((Iterable)super.m_49635_(state, builder));
        if (state.m_60713_((Block)this)) {
            if (this.isPlaceable(state)) {
                PedestalBlockEntity pedestal;
                BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
                if (blockEntity instanceof PedestalBlockEntity && !(pedestal = (PedestalBlockEntity)blockEntity).m_7983_()) {
                    drop.add(pedestal.m_8020_(0));
                }
            } else {
                return drop;
            }
        }
        return drop;
    }

    private void moveStoredStack(LevelAccessor world, BlockState state, BlockPos pos) {
        PedestalBlockEntity pedestal;
        ItemStack stack;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PedestalBlockEntity && state.m_60713_((Block)this) && !(stack = (pedestal = (PedestalBlockEntity)blockEntity).m_8016_(0)).m_41619_()) {
            this.moveStoredStack(blockEntity, world, stack, pos.m_7494_());
        }
    }

    private void moveStoredStack(BlockEntity blockEntity, LevelAccessor world, ItemStack stack, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!state.m_60713_((Block)this)) {
            this.dropStoredStack(blockEntity, stack, pos);
        } else if (((EndBlockProperties.PedestalState)((Object)state.m_61143_(STATE))).equals((Object)EndBlockProperties.PedestalState.PILLAR)) {
            this.moveStoredStack(blockEntity, world, stack, pos.m_7494_());
        } else if (!this.isPlaceable(state)) {
            this.dropStoredStack(blockEntity, stack, pos);
        } else if (blockEntity instanceof PedestalBlockEntity) {
            PedestalBlockEntity pedestal = (PedestalBlockEntity)blockEntity;
            if (pedestal.m_7983_()) {
                pedestal.m_6836_(0, stack);
            } else {
                this.dropStoredStack(blockEntity, stack, pos);
            }
        } else {
            this.dropStoredStack(blockEntity, stack, pos);
        }
    }

    private void dropStoredStack(BlockEntity blockEntity, ItemStack stack, BlockPos pos) {
        if (blockEntity != null && blockEntity.m_58904_() != null) {
            Level world = blockEntity.m_58904_();
            Block.m_49840_((Level)world, (BlockPos)this.getDropPos((LevelAccessor)world, pos), (ItemStack)stack);
        }
    }

    private BlockPos getDropPos(LevelAccessor world, BlockPos pos) {
        if (world.m_8055_(pos).m_60795_()) {
            return pos;
        }
        if (world.m_8055_(pos.m_7494_()).m_60795_()) {
            return pos.m_7494_();
        }
        for (int i = 2; i < Direction.values().length; ++i) {
            BlockPos dropPos = pos.m_121945_(Direction.m_122376_((int)i));
            if (!world.m_8055_(dropPos).m_60795_()) continue;
            return dropPos.m_7949_();
        }
        return this.getDropPos(world, pos.m_7494_());
    }

    public boolean isPlaceable(BlockState state) {
        if (!state.m_60713_((Block)this)) {
            return false;
        }
        EndBlockProperties.PedestalState currentState = (EndBlockProperties.PedestalState)((Object)state.m_61143_(STATE));
        return currentState == EndBlockProperties.PedestalState.DEFAULT || currentState == EndBlockProperties.PedestalState.PEDESTAL_TOP;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_60713_((Block)this)) {
            switch ((EndBlockProperties.PedestalState)((Object)state.m_61143_(STATE))) {
                case BOTTOM: {
                    return SHAPE_BOTTOM;
                }
                case PEDESTAL_TOP: {
                    return SHAPE_PEDESTAL_TOP;
                }
                case COLUMN_TOP: {
                    return SHAPE_COLUMN_TOP;
                }
                case PILLAR: {
                    return SHAPE_PILLAR;
                }
                case COLUMN: {
                    return SHAPE_COLUMN;
                }
            }
            return SHAPE_DEFAULT;
        }
        return super.m_5940_(state, world, pos, context);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{STATE, HAS_ITEM, HAS_LIGHT});
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new PedestalBlockEntity(blockPos, blockState);
    }

    public boolean hasUniqueEntity() {
        return false;
    }

    public boolean m_7278_(BlockState state) {
        return state.m_60734_() instanceof PedestalBlock;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)HAS_ITEM) != false ? 15 : 0;
    }

    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation blockId) {
        return this.getBlockModel(blockId, this.m_49966_());
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation resourceLocation, BlockState blockState) {
        Map<String, String> textures = this.createTexturesMap();
        EndBlockProperties.PedestalState state = (EndBlockProperties.PedestalState)((Object)blockState.m_61143_(STATE));
        Optional<String> pattern = Patterns.createJson(Patterns.BLOCK_PEDESTAL_DEFAULT, textures);
        switch (state) {
            case COLUMN_TOP: {
                pattern = Patterns.createJson(Patterns.BLOCK_PEDESTAL_COLUMN_TOP, textures);
                break;
            }
            case COLUMN: {
                pattern = Patterns.createJson(Patterns.BLOKC_PEDESTAL_COLUMN, textures);
                break;
            }
            case PEDESTAL_TOP: {
                pattern = Patterns.createJson(Patterns.BLOCK_PEDESTAL_TOP, textures);
                break;
            }
            case BOTTOM: {
                pattern = Patterns.createJson(Patterns.BLOCK_PEDESTAL_BOTTOM, textures);
                break;
            }
            case PILLAR: {
                pattern = Patterns.createJson(Patterns.BLOCK_PEDESTAL_PILLAR, textures);
                break;
            }
        }
        return ModelsHelper.fromPattern(pattern);
    }

    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        EndBlockProperties.PedestalState state = (EndBlockProperties.PedestalState)((Object)blockState.m_61143_(STATE));
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + "_" + state);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        return ModelsHelper.createBlockSimple((ResourceLocation)modelId);
    }

    protected Map<String, String> createTexturesMap() {
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)this.parent);
        String name = blockId.m_135815_();
        HashMap textures = Maps.newHashMap();
        textures.put("%mod%", blockId.m_135827_());
        textures.put("%top%", name + "_top");
        textures.put("%base%", name + "_base");
        textures.put("%pillar%", name + "_pillar");
        textures.put("%bottom%", name + "_bottom");
        return textures;
    }

    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add(EndTags.PEDESTALS);
    }

    static {
        VoxelShape basinUp = Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
        VoxelShape basinDown = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape columnTopUp = Block.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        VoxelShape columnTopDown = Block.m_49796_((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
        VoxelShape pedestalTop = Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
        VoxelShape pedestalDefault = Block.m_49796_((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        VoxelShape pillar = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
        VoxelShape pillarDefault = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        VoxelShape columnTop = Shapes.m_83110_((VoxelShape)columnTopDown, (VoxelShape)columnTopUp);
        VoxelShape basin = Shapes.m_83110_((VoxelShape)basinDown, (VoxelShape)basinUp);
        SHAPE_PILLAR = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        SHAPE_DEFAULT = Shapes.m_83124_((VoxelShape)basin, (VoxelShape[])new VoxelShape[]{pillarDefault, pedestalDefault});
        SHAPE_PEDESTAL_TOP = Shapes.m_83110_((VoxelShape)pillar, (VoxelShape)pedestalTop);
        SHAPE_COLUMN_TOP = Shapes.m_83110_((VoxelShape)SHAPE_PILLAR, (VoxelShape)columnTop);
        SHAPE_COLUMN = Shapes.m_83124_((VoxelShape)basin, (VoxelShape[])new VoxelShape[]{SHAPE_PILLAR, columnTop});
        SHAPE_BOTTOM = Shapes.m_83110_((VoxelShape)basin, (VoxelShape)SHAPE_PILLAR);
    }
}

