/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.betterx.bclib.behaviours.interfaces.BehaviourWaterPlantSeed;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.blocks.UnderwaterPlantWithAgeBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.EndLotusLeafBlock;
import org.betterx.betterend.blocks.EndLotusStemBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class EndLotusSeedBlock
extends UnderwaterPlantWithAgeBlock
implements BehaviourWaterPlantSeed {
    public void grow(WorldGenLevel world, RandomSource random, BlockPos pos) {
        if (this.canGrow(world, pos)) {
            BlockState startLeaf = (BlockState)EndBlocks.END_LOTUS_STEM.m_49966_().m_61124_((Property)EndLotusStemBlock.LEAF, (Comparable)Boolean.valueOf(true));
            BlockState roots = (BlockState)((BlockState)EndBlocks.END_LOTUS_STEM.m_49966_().m_61124_(EndLotusStemBlock.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)).m_61124_((Property)EndLotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            BlockState stem = EndBlocks.END_LOTUS_STEM.m_49966_();
            BlockState flower = EndBlocks.END_LOTUS_FLOWER.m_49966_();
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)roots);
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
            bpos.m_142448_(bpos.m_123342_() + 1);
            while (world.m_6425_((BlockPos)bpos).m_76170_()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)stem.m_61124_((Property)EndLotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))));
                bpos.m_142448_(bpos.m_123342_() + 1);
            }
            int height = random.m_188499_() ? 0 : (random.m_188499_() ? 1 : (random.m_188499_() ? 1 : -1));
            BlockProperties.TripleShape shape = height == 0 ? BlockProperties.TripleShape.TOP : BlockProperties.TripleShape.MIDDLE;
            Direction dir = BlocksHelper.randomHorizontal((RandomSource)random);
            BlockPos leafCenter = bpos.m_7949_().m_121945_(dir);
            if (this.hasLeaf(world, leafCenter)) {
                this.generateLeaf(world, leafCenter);
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)((BlockState)startLeaf.m_61124_(EndLotusStemBlock.SHAPE, (Comparable)shape)).m_61124_(EndLotusStemBlock.FACING, (Comparable)dir)));
            } else {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)stem.m_61124_(EndLotusStemBlock.SHAPE, (Comparable)shape)));
            }
            bpos.m_142448_(bpos.m_123342_() + 1);
            for (int i = 1; i <= height; ++i) {
                if (!world.m_46859_((BlockPos)bpos)) {
                    bpos.m_142448_(bpos.m_123342_() - 1);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)flower);
                    bpos.m_142448_(bpos.m_123342_() - 1);
                    stem = world.m_8055_((BlockPos)bpos);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)stem.m_61124_(EndLotusStemBlock.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
                    return;
                }
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)stem);
                bpos.m_142448_(bpos.m_123342_() + 1);
            }
            if (!world.m_46859_((BlockPos)bpos) || height < 0) {
                bpos.m_142448_(bpos.m_123342_() - 1);
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)flower);
            bpos.m_142448_(bpos.m_123342_() - 1);
            stem = world.m_8055_((BlockPos)bpos);
            if (!stem.m_60713_(EndBlocks.END_LOTUS_STEM)) {
                stem = EndBlocks.END_LOTUS_STEM.m_49966_();
                if (!world.m_8055_(bpos.m_122012_()).m_60819_().m_76178_()) {
                    stem = (BlockState)stem.m_61124_((Property)EndLotusStemBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
            }
            if (world.m_8055_(bpos.m_121945_(dir)).m_60713_(EndBlocks.END_LOTUS_LEAF)) {
                stem = (BlockState)((BlockState)stem.m_61124_((Property)EndLotusStemBlock.LEAF, (Comparable)Boolean.valueOf(true))).m_61124_(EndLotusStemBlock.FACING, (Comparable)dir);
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)stem.m_61124_(EndLotusStemBlock.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
        }
    }

    private boolean canGrow(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
        bpos.m_122190_((Vec3i)pos);
        while (world.m_8055_((BlockPos)bpos).m_60819_().m_76152_().equals(Fluids.f_76193_.m_5613_())) {
            bpos.m_142448_(bpos.m_123342_() + 1);
        }
        return world.m_46859_((BlockPos)bpos) && world.m_46859_(bpos.m_7494_());
    }

    private void generateLeaf(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockState leaf = EndBlocks.END_LOTUS_LEAF.m_49966_();
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)leaf.m_61124_(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)));
        for (Direction move : BlocksHelper.HORIZONTAL) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p.m_122190_((Vec3i)pos).m_122173_(move), (BlockState)((BlockState)((BlockState)leaf.m_61124_(EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)move)).m_61124_(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE)));
        }
        for (int i = 0; i < 4; ++i) {
            Direction d1 = BlocksHelper.HORIZONTAL[i];
            Direction d2 = BlocksHelper.HORIZONTAL[i + 1 & 3];
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p.m_122190_((Vec3i)pos).m_122173_(d1).m_122173_(d2), (BlockState)((BlockState)((BlockState)leaf.m_61124_(EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)d1)).m_61124_(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
        }
    }

    private boolean hasLeaf(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        p.m_142448_(pos.m_123342_());
        int count = 0;
        for (int x = -1; x < 2; ++x) {
            p.m_142451_(pos.m_123341_() + x);
            for (int z = -1; z < 2; ++z) {
                p.m_142443_(pos.m_123343_() + z);
                if (!world.m_46859_((BlockPos)p) || world.m_6425_(p.m_7495_()).m_76178_()) continue;
                ++count;
            }
        }
        return count == 9;
    }

    protected boolean isTerrain(BlockState state) {
        return state.m_204336_(CommonBlockTags.END_STONES);
    }
}

