/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math.sdf.shapes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.shapes.BaseShape;
import net.minecraft.util.KeyDispatchDataCodec;

public class Sphere
extends BaseShape {
    public static final Transform DEFAULT_TRANSFORM = Transform.of(Float3.of(0.0, 0.0, 0.0), Float3.of(8.0, 8.0, 8.0));
    public static final Codec<Sphere> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Transform.CODEC.fieldOf("transform").orElse((Object)Transform.IDENTITY).forGetter(o -> o.transform), (App)Codec.INT.fieldOf("material").orElse((Object)0).forGetter(BaseShape::getMaterialIndex)).apply((Applicative)instance, Sphere::new));
    public static final KeyDispatchDataCodec<Sphere> CODEC = KeyDispatchDataCodec.m_216236_(DIRECT_CODEC);

    @Override
    public KeyDispatchDataCodec<? extends SDF> codec() {
        return CODEC;
    }

    public Sphere(Transform t, int matIndex) {
        super(t, matIndex);
    }

    public Sphere(Transform t) {
        this(t, 0);
    }

    public Sphere(Float3 center, double radius) {
        super(Transform.of(center, Float3.of(radius * 2.0)), 0);
    }

    @Override
    public double dist(Float3 pos) {
        pos = this.getParentTransformMatrix().inverted().transform(pos);
        return pos.sub(this.getCenter()).length() - this.getRadius();
    }

    public double getRadius() {
        return this.transform.size.min() / 2.0;
    }

    @Override
    public Transform defaultTransform() {
        return DEFAULT_TRANSFORM;
    }
}

