/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.worlds.together.worldPreset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import org.betterx.bclib.BCLib;
import org.betterx.worlds.together.WorldsTogether;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.mixin.common.WorldPresetAccessor;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.betterx.worlds.together.worldPreset.WorldPresets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TogetherWorldPreset
extends WorldPreset {
    public final int sortOrder;
    private static int NEXT_IN_SORT_ORDER = 1000;
    private final WorldDimensions worldDimensions;
    @Nullable
    public final ResourceKey<WorldPreset> parentKey;
    private static DimensionsWrapper DEFAULT_DIMENSIONS_WRAPPER = null;

    public TogetherWorldPreset(Map<ResourceKey<LevelStem>, LevelStem> map, Optional<Integer> sortOrder) {
        this(map, sortOrder.orElse(NEXT_IN_SORT_ORDER++), null);
    }

    public TogetherWorldPreset(Map<ResourceKey<LevelStem>, LevelStem> map, Optional<Integer> sortOrder, @Nullable ResourceKey<WorldPreset> parentKey) {
        this(map, sortOrder.orElse(NEXT_IN_SORT_ORDER++), parentKey);
    }

    public TogetherWorldPreset(Map<ResourceKey<LevelStem>, LevelStem> map, int sortOrder) {
        this(map, sortOrder, null);
    }

    public TogetherWorldPreset(Map<ResourceKey<LevelStem>, LevelStem> map, int sortOrder, @Nullable ResourceKey<WorldPreset> parentKey) {
        super(map);
        this.sortOrder = sortOrder;
        this.worldDimensions = TogetherWorldPreset.buildWorldDimensions(map);
        this.parentKey = parentKey;
    }

    public static WorldDimensions buildWorldDimensions(Map<ResourceKey<LevelStem>, LevelStem> map) {
        MappedRegistry registry = new MappedRegistry(Registries.f_256862_, Lifecycle.experimental());
        for (Map.Entry<ResourceKey<LevelStem>, LevelStem> entry : map.entrySet()) {
            Registry.m_194579_((Registry)registry, entry.getKey(), (Object)entry.getValue());
        }
        return new WorldDimensions((Registry)registry);
    }

    public WorldDimensions getWorldDimensions() {
        return this.worldDimensions;
    }

    public TogetherWorldPreset withDimensions(Registry<LevelStem> dimensions, @Nullable ResourceKey<WorldPreset> parentKey) {
        HashMap<ResourceKey<LevelStem>, LevelStem> map = new HashMap<ResourceKey<LevelStem>, LevelStem>();
        for (Map.Entry entry : dimensions.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            LevelStem stem = (LevelStem)entry.getValue();
            map.put((ResourceKey<LevelStem>)key, stem);
        }
        return new TogetherWorldPreset(map, this.sortOrder, parentKey);
    }

    private Map<ResourceKey<LevelStem>, LevelStem> getDimensions() {
        return ((WorldPresetAccessor)((Object)this)).bcl_getDimensions();
    }

    public Map<ResourceKey<LevelStem>, ChunkGenerator> getDimensionsMap() {
        return DimensionsWrapper.build(this.getDimensions());
    }

    public LevelStem getDimension(ResourceKey<LevelStem> key) {
        return this.getDimensions().get(key);
    }

    public static void writeWorldPresetSettings(WorldDimensions dimensions) {
        TogetherWorldPreset.writeWorldPresetSettings((Registry<LevelStem>)dimensions.f_243948_());
    }

    public static void writeWorldPresetSettings(Registry<LevelStem> dimensions) {
        DimensionsWrapper wrapper = new DimensionsWrapper(dimensions);
        TogetherWorldPreset.writeWorldPresetSettings(wrapper);
    }

    public static void writeWorldPresetSettings(Map<ResourceKey<LevelStem>, LevelStem> settings) {
        DimensionsWrapper wrapper = new DimensionsWrapper(DimensionsWrapper.build(settings));
        TogetherWorldPreset.writeWorldPresetSettings(wrapper);
    }

    public static void writeWorldPresetSettingsDirect(Map<ResourceKey<LevelStem>, ChunkGenerator> settings) {
        DimensionsWrapper wrapper = new DimensionsWrapper(settings);
        TogetherWorldPreset.writeWorldPresetSettings(wrapper);
    }

    private static void writeWorldPresetSettings(DimensionsWrapper wrapper) {
        RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)WorldBootstrap.getLastRegistryAccessOrElseBuiltin());
        DataResult encodeResult = DimensionsWrapper.CODEC.encodeStart((DynamicOps)registryOps, (Object)wrapper);
        if (encodeResult.result().isPresent()) {
            CompoundTag settingsNbt = WorldConfig.getRootTag("worlds_together");
            settingsNbt.m_128365_("preset", (Tag)encodeResult.result().get());
        } else {
            WorldsTogether.LOGGER.error("Unable to encode world generator settings for level.dat.");
        }
        WorldConfig.saveFile("worlds_together");
    }

    @NotNull
    public static Map<ResourceKey<LevelStem>, ChunkGenerator> loadWorldDimensions() {
        try {
            CompoundTag presetNBT;
            RegistryAccess registryAccess = WorldBootstrap.getLastRegistryAccessOrElseBuiltin();
            RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)registryAccess);
            if (DEFAULT_DIMENSIONS_WRAPPER == null) {
                DEFAULT_DIMENSIONS_WRAPPER = new DimensionsWrapper(TogetherWorldPreset.getDimensionsMap(WorldPresets.getDEFAULT()));
            }
            if (!(presetNBT = WorldGenUtil.getPresetsNbt()).m_128441_("dimensions")) {
                return TogetherWorldPreset.DEFAULT_DIMENSIONS_WRAPPER.dimensions;
            }
            Optional oLevelStem = DimensionsWrapper.CODEC.parse(new Dynamic((DynamicOps)registryOps, (Object)presetNBT)).resultOrPartial(WorldsTogether.LOGGER::error);
            return oLevelStem.orElse(TogetherWorldPreset.DEFAULT_DIMENSIONS_WRAPPER).dimensions;
        }
        catch (Exception e) {
            BCLib.LOGGER.error("Failed to load Dimensions", e);
            return TogetherWorldPreset.DEFAULT_DIMENSIONS_WRAPPER.dimensions;
        }
    }

    @Nullable
    public static Registry<LevelStem> getDimensions(ResourceKey<WorldPreset> key) {
        RegistryAccess access = WorldBootstrap.getLastRegistryAccessOrElseBuiltin();
        if (access == null) {
            WorldsTogether.LOGGER.error("No valid registry found!");
            return null;
        }
        Optional preset = access.m_175515_(Registries.f_256729_).m_203636_(key);
        if (preset.isEmpty()) {
            return null;
        }
        return ((WorldPreset)((Holder.Reference)preset.get()).m_203334_()).m_247748_().f_243948_();
    }

    @NotNull
    public static Map<ResourceKey<LevelStem>, ChunkGenerator> getDimensionsMap(ResourceKey<WorldPreset> key) {
        Registry<LevelStem> reg = TogetherWorldPreset.getDimensions(key);
        if (reg == null) {
            return new HashMap<ResourceKey<LevelStem>, ChunkGenerator>();
        }
        return DimensionsWrapper.build(reg);
    }

    @NotNull
    public static Map<ResourceKey<LevelStem>, ChunkGenerator> getDimensionMap(WorldDimensions worldDims) {
        return DimensionsWrapper.build((Registry<LevelStem>)worldDims.f_243948_());
    }

    @NotNull
    public static WorldDimensions getWorldDimensions(ResourceKey<WorldPreset> key) {
        Registry<LevelStem> reg = TogetherWorldPreset.getDimensions(key);
        return new WorldDimensions(reg);
    }

    private static class DimensionsWrapper {
        public static final Codec<DimensionsWrapper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256862_), (Codec)ChunkGenerator.f_62136_).fieldOf("dimensions").orElse(new HashMap()).forGetter(o -> o.dimensions)).apply((Applicative)instance, DimensionsWrapper::new));
        final Map<ResourceKey<LevelStem>, ChunkGenerator> dimensions;

        static Map<ResourceKey<LevelStem>, ChunkGenerator> build(Registry<LevelStem> dimensions) {
            HashMap<ResourceKey<LevelStem>, ChunkGenerator> map = new HashMap<ResourceKey<LevelStem>, ChunkGenerator>();
            for (Map.Entry entry : dimensions.m_6579_()) {
                ResourceKey key = (ResourceKey)entry.getKey();
                LevelStem stem = (LevelStem)entry.getValue();
                map.put((ResourceKey<LevelStem>)key, stem.f_63976_());
            }
            return map;
        }

        static Map<ResourceKey<LevelStem>, ChunkGenerator> build(Map<ResourceKey<LevelStem>, LevelStem> input) {
            HashMap<ResourceKey<LevelStem>, ChunkGenerator> map = new HashMap<ResourceKey<LevelStem>, ChunkGenerator>();
            for (Map.Entry<ResourceKey<LevelStem>, LevelStem> entry : input.entrySet()) {
                ResourceKey<LevelStem> key = entry.getKey();
                LevelStem stem = entry.getValue();
                map.put(key, stem.f_63976_());
            }
            return map;
        }

        DimensionsWrapper(Registry<LevelStem> dimensions) {
            this(DimensionsWrapper.build(dimensions));
        }

        private DimensionsWrapper(Map<ResourceKey<LevelStem>, ChunkGenerator> dimensions) {
            this.dimensions = dimensions;
        }
    }
}

