/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class StructureErode {
    private static final Direction[] DIR = BlocksHelper.makeHorizontal();

    public static void erode(WorldGenLevel world, BoundingBox bounds, int iterations, RandomSource random) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        boolean canDestruct = true;
        for (int i = 0; i < iterations; ++i) {
            for (int x = bounds.m_162395_(); x <= bounds.m_162399_(); ++x) {
                mut.m_142451_(x);
                block2: for (int z = bounds.m_162398_(); z <= bounds.m_162401_(); ++z) {
                    mut.m_142443_(z);
                    for (int y = bounds.m_162400_(); y >= bounds.m_162396_(); --y) {
                        mut.m_142448_(y);
                        BlockState state = world.m_8055_((BlockPos)mut);
                        boolean ignore = StructureErode.ignore(state, world, (BlockPos)mut);
                        if (canDestruct && BlocksHelper.isInvulnerable(state, (BlockGetter)world, (BlockPos)mut) && random.m_188503_(8) == 0 && world.m_46859_(mut.m_6625_(2))) {
                            int r = MHelper.randRange(1, 4, random);
                            int cx = mut.m_123341_();
                            int cy = mut.m_123342_();
                            int cz = mut.m_123343_();
                            int x1 = cx - r;
                            int y1 = cy - r;
                            int z1 = cz - r;
                            int x2 = cx + r;
                            int y2 = cy + r;
                            int z2 = cz + r;
                            for (int px = x1; px <= x2; ++px) {
                                int dx = px - cx;
                                dx *= dx;
                                mut.m_142451_(px);
                                for (int py = y1; py <= y2; ++py) {
                                    int dy = py - cy;
                                    dy *= dy;
                                    mut.m_142448_(py);
                                    for (int pz = z1; pz <= z2; ++pz) {
                                        int dz = pz - cz;
                                        dz *= dz;
                                        mut.m_142443_(pz);
                                        if (dx + dy + dz > r || !BlocksHelper.isInvulnerable(world.m_8055_((BlockPos)mut), (BlockGetter)world, (BlockPos)mut)) continue;
                                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.f_50016_);
                                    }
                                }
                            }
                            mut.m_142451_(cx);
                            mut.m_142448_(cy);
                            mut.m_142443_(cz);
                            canDestruct = false;
                            continue;
                        }
                        if (ignore) continue;
                        if (!state.m_60795_() && random.m_188499_()) {
                            MHelper.shuffle(DIR, random);
                            block7: for (Direction dir : DIR) {
                                if (!world.m_46859_(mut.m_121945_(dir)) || !world.m_46859_(mut.m_7495_().m_121945_(dir))) continue;
                                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.f_50016_);
                                mut.m_122173_(dir).m_122173_(Direction.DOWN);
                                int py = mut.m_123342_();
                                while (y >= bounds.m_162396_() - 10) {
                                    mut.m_142448_(py - 1);
                                    if (!world.m_46859_((BlockPos)mut)) {
                                        mut.m_142448_(py);
                                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, state);
                                        continue block7;
                                    }
                                    --y;
                                }
                            }
                            continue block2;
                        }
                        if (random.m_188503_(8) != 0 || BlocksHelper.isInvulnerable(world.m_8055_(mut.m_7494_()), (BlockGetter)world, (BlockPos)mut)) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.f_50016_);
                    }
                }
            }
        }
        for (int x = bounds.m_162395_(); x <= bounds.m_162399_(); ++x) {
            mut.m_142451_(x);
            for (int z = bounds.m_162398_(); z <= bounds.m_162401_(); ++z) {
                mut.m_142443_(z);
                block11: for (int y = bounds.m_162400_(); y >= bounds.m_162396_(); --y) {
                    mut.m_142448_(y);
                    BlockState state = world.m_8055_((BlockPos)mut);
                    if (StructureErode.ignore(state, world, (BlockPos)mut) || !world.m_46859_(mut.m_7495_())) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.f_50016_);
                    for (int py = mut.m_123342_(); py >= bounds.m_162396_() - 10; --py) {
                        mut.m_142448_(py - 1);
                        if (world.m_46859_((BlockPos)mut)) continue;
                        mut.m_142448_(py);
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, state);
                        continue block11;
                    }
                }
            }
        }
    }

    public static void erodeIntense(WorldGenLevel world, BoundingBox bounds, RandomSource random) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mut2 = new BlockPos.MutableBlockPos();
        int minY = bounds.m_162396_() - 10;
        for (int x = bounds.m_162395_(); x <= bounds.m_162399_(); ++x) {
            mut.m_142451_(x);
            for (int z = bounds.m_162398_(); z <= bounds.m_162401_(); ++z) {
                mut.m_142443_(z);
                for (int y = bounds.m_162400_(); y >= bounds.m_162396_(); --y) {
                    mut.m_142448_(y);
                    BlockState state = world.m_8055_((BlockPos)mut);
                    if (StructureErode.ignore(state, world, (BlockPos)mut)) continue;
                    if (random.m_188503_(6) == 0) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.f_50016_);
                        if (!random.m_188499_()) continue;
                        int px = MHelper.floor(random.m_188583_() * 2.0 + (double)x + 0.5);
                        int pz = MHelper.floor(random.m_188583_() * 2.0 + (double)z + 0.5);
                        mut2.m_122178_(px, y, pz);
                        while (world.m_8055_((BlockPos)mut2).m_247087_() && mut2.m_123342_() > minY) {
                            mut2.m_142448_(mut2.m_123342_() - 1);
                        }
                        if (world.m_8055_((BlockPos)mut2).m_60795_() || !state.m_60710_((LevelReader)world, (BlockPos)mut2)) continue;
                        mut2.m_142448_(mut2.m_123342_() + 1);
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut2, state);
                        continue;
                    }
                    if (random.m_188503_(8) != 0) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.f_50016_);
                }
            }
        }
        StructureErode.drop(world, bounds);
    }

    private static void drop(WorldGenLevel world, BoundingBox bounds) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        HashSet blocks = Sets.newHashSet();
        HashSet edge = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        for (int x = bounds.m_162395_(); x <= bounds.m_162399_(); ++x) {
            mut.m_142451_(x);
            for (int z = bounds.m_162398_(); z <= bounds.m_162401_(); ++z) {
                mut.m_142443_(z);
                for (int y = bounds.m_162396_(); y <= bounds.m_162400_(); ++y) {
                    mut.m_142448_(y);
                    BlockState state = world.m_8055_((BlockPos)mut);
                    if (StructureErode.ignore(state, world, (BlockPos)mut) || !StructureErode.isTerrainNear(world, (BlockPos)mut)) continue;
                    edge.add(mut.m_7949_());
                }
            }
        }
        if (edge.isEmpty()) {
            return;
        }
        while (!edge.isEmpty()) {
            for (BlockPos center : edge) {
                for (Direction dir : BlocksHelper.DIRECTIONS) {
                    BlockState state = world.m_8055_(center);
                    if (!state.m_60838_((BlockGetter)world, center)) continue;
                    mut.m_122190_((Vec3i)center).m_122173_(dir);
                    if (!bounds.m_71051_((Vec3i)mut) || StructureErode.ignore(state = world.m_8055_((BlockPos)mut), world, (BlockPos)mut) || blocks.contains(mut)) continue;
                    add.add(mut.m_7949_());
                }
            }
            blocks.addAll(edge);
            edge.clear();
            edge.addAll(add);
            add.clear();
        }
        int minY = bounds.m_162396_() - 10;
        for (int x = bounds.m_162395_(); x <= bounds.m_162399_(); ++x) {
            mut.m_142451_(x);
            for (int z = bounds.m_162398_(); z <= bounds.m_162401_(); ++z) {
                mut.m_142443_(z);
                for (int y = bounds.m_162396_(); y <= bounds.m_162400_(); ++y) {
                    mut.m_142448_(y);
                    BlockState state = world.m_8055_((BlockPos)mut);
                    if (StructureErode.ignore(state, world, (BlockPos)mut) || blocks.contains(mut)) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, Blocks.f_50016_);
                    while (world.m_8055_((BlockPos)mut).m_247087_() && mut.m_123342_() > minY) {
                        mut.m_142448_(mut.m_123342_() - 1);
                    }
                    if (mut.m_123342_() <= minY) continue;
                    mut.m_142448_(mut.m_123342_() + 1);
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, state);
                }
            }
        }
    }

    private static boolean ignore(BlockState state, WorldGenLevel world, BlockPos pos) {
        if (state.m_204336_(CommonBlockTags.GEN_END_STONES) || state.m_204336_(BlockTags.f_13077_)) {
            return true;
        }
        return !state.m_280603_().equals((Object)NoteBlockInstrument.BASEDRUM) || BlocksHelper.isInvulnerable(state, (BlockGetter)world, pos);
    }

    private static boolean isTerrainNear(WorldGenLevel world, BlockPos pos) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (!world.m_8055_(pos.m_121945_(dir)).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
            return true;
        }
        return false;
    }

    public static void cover(WorldGenLevel world, BoundingBox bounds, RandomSource random, BlockState defaultBlock) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        for (int x = bounds.m_162395_(); x <= bounds.m_162399_(); ++x) {
            mut.m_142451_(x);
            for (int z = bounds.m_162398_(); z <= bounds.m_162401_(); ++z) {
                mut.m_142443_(z);
                BlockState top = BiomeAPI.findTopMaterial((Holder<Biome>)world.m_204166_((BlockPos)mut)).orElse(defaultBlock);
                if (top == null) continue;
                for (int y = bounds.m_162400_(); y >= bounds.m_162396_(); --y) {
                    mut.m_142448_(y);
                    BlockState state = world.m_8055_((BlockPos)mut);
                    if (!state.m_204336_(CommonBlockTags.TERRAIN) || world.m_8055_(mut.m_7494_()).m_280296_()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, top);
                }
            }
        }
    }
}

