/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.recipes;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.recipes.AbstractUnlockableRecipeBuilder;

public class CookingRecipeBuilder
extends AbstractUnlockableRecipeBuilder<CookingRecipeBuilder> {
    protected float xp = 0.0f;
    protected int cookingTime = 200;
    boolean blasting;
    boolean campfire;
    boolean smoker;
    boolean smelting = true;

    static CookingRecipeBuilder make(ResourceLocation id, ItemLike output) {
        return new CookingRecipeBuilder(id, output);
    }

    protected CookingRecipeBuilder(ResourceLocation id, ItemLike output) {
        super(id, output);
    }

    @Deprecated(forRemoval=true)
    public CookingRecipeBuilder setInput(ItemLike in) {
        return (CookingRecipeBuilder)this.setPrimaryInputAndUnlock(in);
    }

    @Deprecated(forRemoval=true)
    public CookingRecipeBuilder setInput(TagKey<Item> in) {
        return (CookingRecipeBuilder)this.setPrimaryInputAndUnlock(in);
    }

    public CookingRecipeBuilder setExperience(float xp) {
        this.xp = xp;
        return this;
    }

    public CookingRecipeBuilder setCookingTime(int time) {
        this.cookingTime = time;
        return this;
    }

    @Override
    protected boolean checkRecipe() {
        if (!(this.smelting || this.blasting || this.campfire || this.smoker)) {
            BCLib.LOGGER.warning("No target (smelting, blasting, campfire or somer) for cooking recipe was selected. Recipe {} will be ignored!", this.id);
            return false;
        }
        if (this.cookingTime < 0) {
            BCLib.LOGGER.warning("cooking time must be positive. Recipe {} will be ignored!", this.id);
            return false;
        }
        return super.checkRecipe();
    }

    public CookingRecipeBuilder enableSmelter() {
        this.smelting = true;
        return this;
    }

    public CookingRecipeBuilder disableSmelter() {
        this.smelting = false;
        return this;
    }

    public CookingRecipeBuilder enableBlastFurnace() {
        this.blasting = true;
        return this;
    }

    public CookingRecipeBuilder disableBlastFurnace() {
        this.blasting = false;
        return this;
    }

    public CookingRecipeBuilder enableCampfire() {
        this.campfire = true;
        return this;
    }

    public CookingRecipeBuilder disableCampfire() {
        this.campfire = false;
        return this;
    }

    public CookingRecipeBuilder enableSmoker() {
        this.smoker = true;
        return this;
    }

    public CookingRecipeBuilder disableSmoker() {
        this.smoker = false;
        return this;
    }

    public void build(boolean blasting, boolean campfire, boolean smoker) {
        this.enableSmelter();
        this.blasting = blasting;
        this.campfire = campfire;
        this.smoker = smoker;
        this.build();
    }

    public void buildWithBlasting() {
        this.build(true, false, false);
    }

    public void buildFoodlike() {
        this.build(false, true, true);
    }

    private void buildRecipe(Consumer<FinishedRecipe> cc, SimpleCookingRecipeBuilder builder, String postfix) {
        ResourceLocation loc = new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_" + postfix);
        for (Map.Entry item : this.unlocks.entrySet()) {
            builder.m_126132_((String)item.getKey(), (CriterionTriggerInstance)item.getValue());
        }
        builder.m_126140_(cc, loc);
    }

    @Override
    protected void buildRecipe(Consumer<FinishedRecipe> cc) {
        if (this.smelting) {
            this.buildRecipe(cc, SimpleCookingRecipeBuilder.m_246179_((Ingredient)this.primaryInput, (RecipeCategory)this.category, (ItemLike)this.output.m_41720_(), (float)this.xp, (int)this.cookingTime), "smelting");
        }
        if (this.blasting) {
            this.buildRecipe(cc, SimpleCookingRecipeBuilder.m_245681_((Ingredient)this.primaryInput, (RecipeCategory)this.category, (ItemLike)this.output.m_41720_(), (float)this.xp, (int)(this.cookingTime / 2)), "blasting");
        }
        if (this.campfire) {
            this.buildRecipe(cc, SimpleCookingRecipeBuilder.m_247020_((Ingredient)this.primaryInput, (RecipeCategory)this.category, (ItemLike)this.output.m_41720_(), (float)this.xp, (int)(this.cookingTime * 3)), "campfire");
        }
        if (this.smoker) {
            this.buildRecipe(cc, SimpleCookingRecipeBuilder.m_247020_((Ingredient)this.primaryInput, (RecipeCategory)this.category, (ItemLike)this.output.m_41720_(), (float)this.xp, (int)(this.cookingTime / 2)), "smoker");
        }
    }
}

