/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.items;

import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.blocks.BaseAnvilBlock;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.ItemModelProvider;
import org.jetbrains.annotations.Nullable;

public class BaseAnvilItem
extends BlockItem
implements ItemModelProvider {
    public static final String DESTRUCTION = "destruction";

    public BaseAnvilItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected BlockState m_5965_(BlockPlaceContext blockPlaceContext) {
        BlockState blockState = super.m_5965_(blockPlaceContext);
        ItemStack stack = blockPlaceContext.m_43722_();
        int destruction = stack.m_41784_().m_128451_(DESTRUCTION);
        if (blockState != null) {
            BaseAnvilBlock block = (BaseAnvilBlock)blockState.m_60734_();
            IntegerProperty durabilityProp = block.getDurabilityProp();
            if (destruction == 0) {
                blockState = (BlockState)((BlockState)blockState.m_61124_((Property)durabilityProp, (Comparable)Integer.valueOf(0))).m_61124_((Property)BaseAnvilBlock.DESTRUCTION, (Comparable)Integer.valueOf(0));
            } else {
                int destructionValue = destruction / block.getMaxDurability();
                int durabilityValue = destruction - destructionValue * block.getMaxDurability();
                blockState = (BlockState)((BlockState)blockState.m_61124_((Property)durabilityProp, (Comparable)Integer.valueOf(durabilityValue))).m_61124_((Property)BaseAnvilBlock.DESTRUCTION, (Comparable)Integer.valueOf(destructionValue));
            }
        }
        return blockState;
    }

    @Environment(value=EnvType.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        int destruction = itemStack.m_41784_().m_128451_(DESTRUCTION);
        if (destruction > 0) {
            BaseAnvilBlock block = (BaseAnvilBlock)((BaseAnvilItem)itemStack.m_41720_()).m_40614_();
            int maxValue = block.getMaxDurability() * 3;
            float damage = maxValue - destruction;
            String percents = String.format(Locale.ROOT, "%.0f%%", Float.valueOf(damage));
            list.add((Component)Component.m_237115_((String)"message.bclib.anvil_damage").m_130946_(": " + percents));
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        Block anvilBlock = this.m_40614_();
        ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)anvilBlock);
        return ((BlockModelProvider)anvilBlock).getBlockModel(blockId, anvilBlock.m_49966_());
    }
}

