/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.integration.emi;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.integration.emi.EMIPlugin;
import org.betterx.bclib.recipes.AnvilRecipe;
import org.jetbrains.annotations.Nullable;

public class EMIAnvilRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final EmiRecipeCategory category;

    public EMIAnvilRecipe(AnvilRecipe recipe, Item hammer) {
        this.id = new ResourceLocation("emi", recipe.m_6423_().m_135827_() + "/" + recipe.m_6423_().m_135815_() + "/anvil/" + hammer.m_5524_());
        this.input = List.of(EmiIngredient.of((Ingredient)recipe.getMainIngredient(), (long)recipe.getInputCount()), EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{hammer})));
        this.output = List.of(EmiStack.of((ItemStack)recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_())));
        this.category = EMIPlugin.getAnvilCategoryForLevel(recipe.getAnvilLevel());
    }

    static void addAllRecipes(EmiRegistry emiRegistry, RecipeManager manager) {
        Iterable<Holder<Item>> hammers = AnvilRecipe.getAllHammers();
        EMIPlugin.addAllRecipes(emiRegistry, manager, BCLib.LOGGER, AnvilRecipe.TYPE, recipe -> StreamSupport.stream(hammers.spliterator(), false).map(Holder::m_203334_).filter(recipe::canUse).toList(), EMIAnvilRecipe::new);
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 104;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 46, 5);
        widgetHolder.addSlot(this.input.get(0), 0, 4);
        widgetHolder.addSlot(this.input.get(1), 20, 4).catalyst(true);
        widgetHolder.addSlot((EmiIngredient)this.output.get(0), 78, 0).large(true).recipeContext((EmiRecipe)this);
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(this.input.get(1));
    }

    public boolean supportsRecipeTree() {
        return true;
    }
}

