/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.client.gui.screens.UpdatesScreen;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.networking.VersionChecker;

public class PrintInfo {
    public static LiteralArgumentBuilder<CommandSourceStack> register(LiteralArgumentBuilder<CommandSourceStack> bnContext) {
        return (LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"print").requires(source -> source.m_6761_(4))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dimensions").requires(source -> source.m_6761_(4))).executes(PrintInfo::printDimensions))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"updates").requires(source -> source.m_6761_(4))).executes(ctx -> PrintInfo.printUpdates((CommandContext<CommandSourceStack>)ctx, true))));
    }

    static int printDimensions(CommandContext<CommandSourceStack> ctx) {
        MutableComponent result = Component.m_237113_((String)"World Dimensions: ").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE));
        for (ServerLevel serverLevel : ((CommandSourceStack)ctx.getSource()).m_81372_().m_7654_().m_129785_()) {
            ChunkGenerator generator = serverLevel.m_7726_().m_8481_();
            String output = "\n - " + serverLevel.m_46472_().m_135782_().toString() + ": \n     " + generator.toString().trim() + " " + generator.m_62218_().toString().replace("\n", "\n     ");
            ChatFormatting cl = ChatFormatting.LIGHT_PURPLE;
            if (serverLevel.m_46472_().m_135782_().equals((Object)Level.f_46428_.m_135782_())) {
                cl = ChatFormatting.WHITE;
            } else if (serverLevel.m_46472_().m_135782_().equals((Object)Level.f_46429_.m_135782_())) {
                cl = ChatFormatting.RED;
            }
            if (serverLevel.m_46472_().m_135782_().equals((Object)Level.f_46430_.m_135782_())) {
                cl = ChatFormatting.YELLOW;
            }
            MutableComponent dimComponent = Component.m_237113_((String)output).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131140_(cl));
            result.m_7220_((Component)dimComponent);
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> result, false);
        return 1;
    }

    static int printUpdates(CommandContext<CommandSourceStack> ctx, boolean withUI) {
        boolean hasOne = false;
        MutableComponent header = Component.m_237113_((String)"Mod Updates:").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131140_(ChatFormatting.WHITE));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> header, false);
        VersionChecker.forEachUpdate((mod, cur, updated) -> {
            ModContainer nfo = FabricLoader.getInstance().getModContainer(mod).orElse(null);
            MutableComponent result = Component.m_237113_((String)" - ").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(false)).m_131140_(ChatFormatting.WHITE));
            if (nfo != null) {
                result.m_7220_((Component)Component.m_237113_((String)nfo.getMetadata().getName()).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131140_(ChatFormatting.WHITE)));
            } else {
                result.m_7220_((Component)Component.m_237113_((String)mod).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131140_(ChatFormatting.WHITE)));
            }
            result.m_7220_((Component)Component.m_237113_((String)": ").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131140_(ChatFormatting.WHITE)));
            result.m_7220_((Component)Component.m_237113_((String)cur).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131140_(ChatFormatting.WHITE)));
            result.m_7220_((Component)Component.m_237113_((String)" -> ").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131140_(ChatFormatting.WHITE)));
            if (nfo != null && nfo.getMetadata().getContact().get("homepage").isPresent()) {
                ClickEvent ce = new ClickEvent(ClickEvent.Action.OPEN_URL, (String)nfo.getMetadata().getContact().get("homepage").get());
                result.m_7220_((Component)Component.m_237113_((String)updated).m_6270_(Style.f_131099_.m_131142_(ce).m_131136_(Boolean.valueOf(false)).m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GREEN)));
                result.m_7220_((Component)Component.m_237113_((String)"  ").m_6270_(Style.f_131099_.m_131142_(ce).m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(false))));
                result = result.m_7220_((Component)Component.m_237113_((String)"[CurseForge]").m_6270_(Style.f_131099_.m_131142_(ce).m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true))));
            } else {
                result.m_7220_((Component)Component.m_237113_((String)updated).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.WHITE)));
                result.m_7220_((Component)Component.m_237113_((String)"  ").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131155_(Boolean.valueOf(false))));
            }
            MutableComponent finalResult = result;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> finalResult, false);
        });
        MutableComponent footer = Component.m_237113_((String)"\n").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.WHITE));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> footer, false);
        if (withUI && BCLib.isClient() && Configs.CLIENT_CONFIG.showUpdateInfo() && !VersionChecker.isEmpty()) {
            UpdatesScreen.showUpdateUI();
        }
        return 1;
    }
}

