/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.KeyDispatchCodec;
import java.awt.Taskbar;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluid;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeData;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.worlds.together.surfaceRules.AssignedSurfaceRule;
import org.betterx.worlds.together.surfaceRules.SurfaceRuleRegistry;

public class DumpDatapack {
    private static final Map<ResourceLocation, Dumper> DUMPERS = new HashMap<ResourceLocation, Dumper>();

    public static LiteralArgumentBuilder<CommandSourceStack> register(LiteralArgumentBuilder<CommandSourceStack> bnContext) {
        return (LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"dump_datapack").requires(source -> source.m_6761_(4))).executes(DumpDatapack::dumpDatapack));
    }

    static int dumpDatapack(CommandContext<CommandSourceStack> ctx) {
        File base = new File(System.getProperty("user.dir"), "bclib_datapack_dump");
        DumpDatapack.dumpDatapack(base, ((CommandSourceStack)ctx.getSource()).m_81372_().m_9598_(), ctx);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Succesfully written to:\n    ").m_7220_((Component)Component.m_237113_((String)base.toString()).m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)))), false);
        return 1;
    }

    public static void dumpDatapack(File base, RegistryAccess registryAccess, CommandContext<CommandSourceStack> ctx) {
        RegistryOps registryOps = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)registryAccess);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder = gsonBuilder.setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        registryAccess.m_206193_().forEach(r -> DumpDatapack.dump(base, r, (RegistryOps<JsonElement>)registryOps, gson));
        BCLib.LOGGER.info("- Serializing Dimensions ");
        for (ServerLevel serverLevel : ((CommandSourceStack)ctx.getSource()).m_81372_().m_7654_().m_129785_()) {
            File f1 = new File(base, serverLevel.m_46472_().m_135782_().m_135827_());
            f1 = new File(f1, "dimension");
            f1 = new File(f1, serverLevel.m_46472_().m_135782_().m_135815_() + ".json");
            f1.getParentFile().mkdirs();
            try {
                LevelStem stem = new LevelStem(serverLevel.m_204156_(), serverLevel.m_7726_().m_8481_());
                Codec codec = LevelStem.f_63970_;
                JsonObject o = codec.encodeStart((DynamicOps)registryOps, (Object)stem).result().orElse(new JsonObject());
                String content = gson.toJson((Object)o);
                try {
                    Files.writeString(f1.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    BCLib.LOGGER.error("        ->> Unable to WRITE: " + e.getMessage());
                }
            }
            catch (Exception e) {
                BCLib.LOGGER.error("      ->> Unable to encode: " + e.getMessage());
            }
        }
    }

    private static <T> void dump(File base, RegistryAccess.RegistryEntry<T> registry, RegistryOps<JsonElement> registryOps, Gson gson) {
        BCLib.LOGGER.info("- Serializing: " + registry.f_206233_().toString());
        DUMPERS.clear();
        DUMPERS.put(Registries.f_256952_.m_135782_(), new Dumper(v -> Biome.f_47429_));
        DUMPERS.put(Registries.f_256911_.m_135782_(), new Dumper(v -> ConfiguredFeature.f_65373_));
        DUMPERS.put(Registries.f_256729_.m_135782_(), new Dumper(v -> WorldPreset.f_226414_));
        DUMPERS.put(Registries.f_256932_.m_135782_(), new Dumper(v -> NoiseGeneratorSettings.f_64430_));
        DUMPERS.put(Registries.f_256944_.m_135782_(), new Dumper(v -> Structure.f_226553_));
        DUMPERS.put(Registries.f_256787_.m_135782_(), new Dumper(v -> DimensionType.f_63843_));
        DUMPERS.put(BCLBiomeRegistry.BCL_BIOMES_REGISTRY.m_135782_(), new Dumper(v -> v.codec().f_216232_()));
        DUMPERS.put(SurfaceRuleRegistry.SURFACE_RULES_REGISTRY.m_135782_(), new Dumper(v -> AssignedSurfaceRule.CODEC));
        DUMPERS.put(Registries.f_257003_.m_135782_(), new Dumper(v -> ConfiguredWorldCarver.f_64846_));
        DUMPERS.put(Registries.f_257011_.m_135782_(), new Dumper(v -> StructureProcessorType.f_74467_));
        DUMPERS.put(Registries.f_256724_.m_135782_(), new Dumper(v -> FlatLevelGeneratorPreset.f_226243_));
        DUMPERS.put(Registries.f_257040_.m_135782_(), new Dumper(v -> DensityFunction.f_208216_));
        DUMPERS.put(Registries.f_256988_.m_135782_(), new Dumper(v -> PlacedFeature.f_191772_));
        DUMPERS.put(Registries.f_256865_.m_135782_(), new Dumper(v -> NormalNoise.NoiseParameters.f_192851_));
        DUMPERS.put(Registries.f_256948_.m_135782_(), new Dumper(v -> StructureTemplatePool.f_210554_));
        DUMPERS.put(Registries.f_256998_.m_135782_(), new Dumper(v -> StructureSet.f_210001_));
        Dumper d = DUMPERS.getOrDefault(registry.f_206233_().m_135782_(), new Dumper(v -> registry.f_206234_().m_194605_()));
        if (d != null) {
            DumpDatapack.dump(base, registry, registryOps, gson, d.codecFunction, d.contentTransform);
        } else {
            BCLib.LOGGER.warning("    No Codec Found", new Object[0]);
        }
    }

    private static <T, S> void dump(File base, RegistryAccess.RegistryEntry<T> registry, RegistryOps<JsonElement> registryOps, Gson gson, Function<Object, Codec<?>> codecFunction, Function<Holder<T>, Object> contentTransform) {
        BCLib.LOGGER.info("   - Serializing Tags");
        DumpDatapack.dumpTags(base, registry, registryOps, gson);
        BCLib.LOGGER.info("   - Serializing Content");
        int[] count = new int[]{0, 0};
        registry.f_206234_().m_6579_().stream().map(e -> (ResourceKey)e.getKey()).map(key -> (Holder.Reference)registry.f_206234_().m_203636_(key).get()).forEach(holder -> {
            File f1 = new File(base, ((ResourceKey)holder.m_203543_().get()).m_135782_().m_135827_());
            f1 = new File(f1, registry.f_206233_().m_135782_().m_135815_());
            f1.mkdirs();
            f1 = new File(f1, ((ResourceKey)holder.m_203543_().get()).m_135782_().m_135815_() + ".json");
            f1.getParentFile().mkdirs();
            Object obj = contentTransform.apply((Holder)holder);
            try {
                Codec codec = (Codec)codecFunction.apply(obj);
                JsonObject o = codec.encodeStart((DynamicOps)registryOps, obj).result().orElse(new JsonObject());
                String content = gson.toJson((Object)o);
                try {
                    Files.writeString(f1.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                    count[0] = count[0] + 1;
                }
                catch (IOException e) {
                    count[1] = count[1] + 1;
                    BCLib.LOGGER.error("        ->> Unable to WRITE: " + e.getMessage());
                }
            }
            catch (Exception e) {
                count[1] = count[1] + 1;
                BCLib.LOGGER.error("      ->> Unable to encode: " + e.getMessage());
            }
        });
        BCLib.LOGGER.info("     -> Wrote " + count[0] + " files (" + count[1] + " errors)");
    }

    private static <T> void dumpDatapackOld(File base, RegistryAccess.RegistryEntry<T> registry, RegistryOps<JsonElement> registryOps, Gson gson) {
        BCLib.LOGGER.info(registry.f_206233_().toString());
        DumpDatapack.dumpTags(base, registry, registryOps, gson);
        registry.f_206234_().m_6579_().stream().map(e -> (ResourceKey)e.getKey()).map(key -> (Holder.Reference)registry.f_206234_().m_203636_(key).get()).forEach(holder -> {
            File f1 = new File(base, ((ResourceKey)holder.m_203543_().get()).m_135782_().m_135827_());
            f1 = new File(f1, registry.f_206233_().m_135782_().m_135815_());
            f1.mkdirs();
            f1 = new File(f1, ((ResourceKey)holder.m_203543_().get()).m_135782_().m_135815_() + ".json");
            f1.getParentFile().mkdirs();
            Codec[] codec = new Codec[]{null};
            Object obj = holder;
            while (obj instanceof Holder) {
                obj = ((Holder)obj).m_203334_();
            }
            if (obj instanceof BiomeSource || obj instanceof Taskbar.Feature) {
                System.out.print("");
            }
            System.out.println(obj.getClass());
            if (obj instanceof Structure) {
                AccessibleObject[] s = (Method[])obj;
                codec[0] = s.m_213658_().m_226884_();
            } else if (obj instanceof BCLBiome) {
                BCLBiome s = (BCLBiome)obj;
                codec[0] = BiomeData.CODEC;
            } else if (obj instanceof StructureProcessorList) {
                StructureProcessorList s = (StructureProcessorList)obj;
                codec[0] = StructureProcessorType.f_74466_;
            } else {
                if (obj instanceof GameEvent) {
                    return;
                }
                if (obj instanceof Fluid) {
                    return;
                }
                if (obj instanceof MobEffect) {
                    return;
                }
                if (obj instanceof BaseStairsBlock) {
                    return;
                }
                if (obj instanceof RuleTestType) {
                    codec[0] = registry.f_206234_().m_194605_();
                } else if (obj instanceof PosRuleTestType) {
                    codec[0] = registry.f_206234_().m_194605_();
                } else if (obj instanceof WorldGenSettings) {
                    codec[0] = registry.f_206234_().m_194605_();
                } else if (obj instanceof LevelStem) {
                    codec[0] = registry.f_206234_().m_194605_();
                }
            }
            if (codec[0] == null) {
                for (AccessibleObject accessibleObject : obj.getClass().getMethods()) {
                    if (Modifier.isStatic(((Method)accessibleObject).getModifiers())) continue;
                    ((Method)accessibleObject).setAccessible(true);
                    if (((Method)accessibleObject).getParameterTypes().length != 0) continue;
                    if (Codec.class.isAssignableFrom(((Method)accessibleObject).getReturnType())) {
                        try {
                            codec[0] = (Codec)((Method)accessibleObject).invoke(obj, new Object[0]);
                            BCLib.LOGGER.debug("      Got Codec from " + (Method)accessibleObject);
                            break;
                        }
                        catch (Exception e) {
                            BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Method)accessibleObject);
                            continue;
                        }
                    }
                    if (KeyDispatchCodec.class.isAssignableFrom(((Method)accessibleObject).getReturnType())) {
                        try {
                            codec[0] = ((KeyDispatchCodec)((Method)accessibleObject).invoke(obj, new Object[0])).codec();
                            BCLib.LOGGER.debug("      Got Codec from " + (Method)accessibleObject);
                            break;
                        }
                        catch (Exception e) {
                            BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Method)accessibleObject);
                            continue;
                        }
                    }
                    if (!KeyDispatchDataCodec.class.isAssignableFrom(((Method)accessibleObject).getReturnType())) continue;
                    try {
                        codec[0] = ((KeyDispatchDataCodec)((Method)accessibleObject).invoke(obj, new Object[0])).f_216232_();
                        BCLib.LOGGER.debug("      Got Codec from " + (Method)accessibleObject);
                        break;
                    }
                    catch (Exception e) {
                        BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Method)accessibleObject);
                    }
                }
            }
            if (codec[0] == null) {
                for (AccessibleObject accessibleObject : obj.getClass().getFields()) {
                    if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !"DIRECT_CODEC".equals(((Field)accessibleObject).getName())) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    try {
                        codec[0] = (Codec)((Field)accessibleObject).get(null);
                        BCLib.LOGGER.debug("      Got Codec from " + (Field)accessibleObject);
                    }
                    catch (Exception e) {
                        BCLib.LOGGER.error("      !!! Unable to get Codec from " + (Field)accessibleObject);
                    }
                }
            }
            if (codec[0] == null) {
                for (AccessibleObject accessibleObject : obj.getClass().getFields()) {
                    if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !"CODEC".equals(((Field)accessibleObject).getName())) continue;
                    try {
                        ((Field)accessibleObject).setAccessible(true);
                        codec[0] = (Codec)((Field)accessibleObject).get(null);
                        BCLib.LOGGER.debug("      Got Codec from " + (Field)accessibleObject);
                    }
                    catch (Exception e) {
                        BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Field)accessibleObject);
                    }
                }
            }
            if (codec[0] == null) {
                for (AccessibleObject accessibleObject : obj.getClass().getFields()) {
                    if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !Codec.class.isAssignableFrom(((Field)accessibleObject).getType())) continue;
                    ((Field)accessibleObject).setAccessible(true);
                    try {
                        codec[0] = (Codec)((Field)accessibleObject).get(null);
                        BCLib.LOGGER.debug("      Got Codec from " + (Field)accessibleObject);
                    }
                    catch (Exception e) {
                        BCLib.LOGGER.error("     !!! Unable to get Codec from " + (Field)accessibleObject);
                    }
                }
            }
            if (codec[0] == null) {
                codec[0] = registry.f_206234_().m_194605_();
            }
            if (codec[0] == null) {
                codec[0] = registry.f_206234_().m_194605_();
            }
            if (codec[0] != null) {
                try {
                    JsonObject o = codec[0].encodeStart((DynamicOps)registryOps, obj).result().orElse(new JsonObject());
                    String content = gson.toJson((Object)o);
                    try {
                        Files.writeString(f1.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        BCLib.LOGGER.error("      ->> Unable to WRITE: " + e.getMessage());
                    }
                }
                catch (Exception e) {
                    BCLib.LOGGER.error("      ->> Unable to encode: " + e.getMessage());
                }
            } else {
                BCLib.LOGGER.error("     !!! Could not determine Codec: " + obj.getClass());
            }
        });
    }

    private static <T> void dumpTags(File base, RegistryAccess.RegistryEntry<T> registry, RegistryOps<JsonElement> registryOps, Gson gson) {
        registry.f_206234_().m_203613_().map(tagKey -> registry.f_206234_().m_203431_(tagKey)).filter(tag -> tag.isPresent()).map(tag -> (HolderSet.Named)tag.get()).forEach(tag -> {
            File f1 = new File(base, tag.m_205839_().f_203868_().m_135827_());
            f1 = new File(f1, "tags");
            f1 = new File(f1, registry.f_206233_().m_135782_().m_135815_());
            f1 = new File(f1, tag.m_205839_().f_203868_().m_135815_() + ".json");
            f1.getParentFile().mkdirs();
            TagFile tf = new TagFile(tag.m_203614_().map(holder -> holder.m_203543_()).filter(k -> k.isPresent()).map(k -> TagEntry.m_215925_((ResourceLocation)((ResourceKey)k.get()).m_135782_())).toList(), true);
            JsonElement o = (JsonElement)TagFile.f_215958_.encodeStart((DynamicOps)registryOps, (Object)tf).result().orElse(new JsonObject());
            String content = gson.toJson(o);
            try {
                Files.writeString(f1.toPath(), (CharSequence)content, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                BCLib.LOGGER.error("      ->> Unable to WRITE: " + e.getMessage());
            }
        });
    }

    private record Dumper<T, C extends Codec<? extends T>, H extends Holder<? extends T>>(Function<T, C> codecFunction, Function<Holder<T>, T> contentTransform) {
        Dumper(Function<T, C> codecFunction) {
            this(codecFunction, h -> h.m_203334_());
        }
    }
}

