/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.models;

import com.google.common.collect.Lists;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.multipart.Condition;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.PatternsHelper;

@Environment(value=EnvType.CLIENT)
public class ModelsHelper {
    public static BlockModel fromPattern(Optional<String> pattern) {
        return pattern.map(BlockModel::m_111463_).orElse(null);
    }

    public static BlockModel createItemModel(ResourceLocation resourceLocation) {
        return ModelsHelper.fromPattern(PatternsHelper.createItemGenerated(resourceLocation));
    }

    public static BlockModel createHandheldItem(ResourceLocation resourceLocation) {
        return ModelsHelper.fromPattern(PatternsHelper.createItemHandheld(resourceLocation));
    }

    public static BlockModel createBlockItem(ResourceLocation resourceLocation) {
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.ITEM_BLOCK, resourceLocation);
        return ModelsHelper.fromPattern(pattern);
    }

    public static BlockModel createBlockEmpty(ResourceLocation resourceLocation) {
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.BLOCK_EMPTY, resourceLocation);
        return ModelsHelper.fromPattern(pattern);
    }

    public static MultiVariant createMultiVariant(ResourceLocation resourceLocation, Transformation transform, boolean uvLock) {
        Variant variant = new Variant(resourceLocation, transform, uvLock, 1);
        return new MultiVariant((List)Lists.newArrayList((Object[])new Variant[]{variant}));
    }

    public static MultiVariant createBlockSimple(ResourceLocation resourceLocation) {
        return ModelsHelper.createMultiVariant(resourceLocation, Transformation.m_121093_(), false);
    }

    public static MultiVariant createFacingModel(ResourceLocation resourceLocation, Direction facing, boolean uvLock, boolean inverted) {
        if (inverted) {
            facing = facing.m_122424_();
        }
        BlockModelRotation rotation = BlockModelRotation.m_119153_((int)0, (int)((int)facing.m_122435_()));
        return ModelsHelper.createMultiVariant(resourceLocation, rotation.m_6189_(), uvLock);
    }

    public static MultiVariant createRotatedModel(ResourceLocation resourceLocation, Direction.Axis axis) {
        BlockModelRotation rotation = BlockModelRotation.X0_Y0;
        switch (axis) {
            case X: {
                rotation = BlockModelRotation.X90_Y90;
                break;
            }
            case Z: {
                rotation = BlockModelRotation.X90_Y0;
                break;
            }
        }
        return ModelsHelper.createMultiVariant(resourceLocation, rotation.m_6189_(), false);
    }

    public static MultiVariant createRandomTopModel(ResourceLocation resourceLocation) {
        return new MultiVariant((List)Lists.newArrayList((Object[])new Variant[]{new Variant(resourceLocation, Transformation.m_121093_(), false, 1), new Variant(resourceLocation, BlockModelRotation.X0_Y90.m_6189_(), false, 1), new Variant(resourceLocation, BlockModelRotation.X0_Y180.m_6189_(), false, 1), new Variant(resourceLocation, BlockModelRotation.X0_Y270.m_6189_(), false, 1)}));
    }

    public static class MultiPartBuilder {
        private final List<ModelPart> modelParts = Lists.newArrayList();
        private final StateDefinition<Block, BlockState> stateDefinition;

        public static MultiPartBuilder create(StateDefinition<Block, BlockState> stateDefinition) {
            return new MultiPartBuilder(stateDefinition);
        }

        private MultiPartBuilder(StateDefinition<Block, BlockState> stateDefinition) {
            this.stateDefinition = stateDefinition;
        }

        public ModelPart part(ResourceLocation modelId) {
            ModelPart part = new ModelPart(modelId);
            return part;
        }

        public MultiPart build() {
            if (this.modelParts.size() > 0) {
                ArrayList selectors = Lists.newArrayList();
                this.modelParts.forEach(modelPart -> {
                    MultiVariant variant = ModelsHelper.createMultiVariant(modelPart.modelId, modelPart.transform, modelPart.uvLock);
                    selectors.add(new Selector(modelPart.condition, variant));
                });
                this.modelParts.clear();
                return new MultiPart(this.stateDefinition, (List)selectors);
            }
            throw new IllegalStateException("At least one model part need to be created.");
        }

        public class ModelPart {
            private final ResourceLocation modelId;
            private Transformation transform = Transformation.m_121093_();
            private Condition condition = Condition.f_111922_;
            private boolean uvLock = false;

            private ModelPart(ResourceLocation modelId) {
                this.modelId = modelId;
            }

            public ModelPart setCondition(Function<BlockState, Boolean> condition) {
                this.condition = stateDefinition -> condition::apply;
                return this;
            }

            public ModelPart setTransformation(Transformation transform) {
                this.transform = transform;
                return this;
            }

            public ModelPart setUVLock(boolean value) {
                this.uvLock = value;
                return this;
            }

            public void add() {
                MultiPartBuilder.this.modelParts.add(this);
            }
        }
    }
}

