/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.screens;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.MultiLineText;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.vanilla.LayoutScreen;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProgressListener;
import org.betterx.bclib.client.gui.screens.AtomicProgressListener;
import org.betterx.bclib.client.gui.screens.ProgressLogoRender;
import org.jetbrains.annotations.Nullable;

public class ProgressScreen
extends LayoutScreen
implements ProgressListener,
AtomicProgressListener {
    static final ResourceLocation BCLIB_LOGO_PIXELATED_LOCATION = new ResourceLocation("bclib", "iconpixelated.png");
    Component description;
    private Component stageComponent;
    private MultiLineText stage;
    private HorizontalStack stageRow;
    private Text progress;
    private ProgressLogoRender progressImage;
    private int currentProgress = 0;
    private AtomicInteger atomicCounter;

    public ProgressScreen(@Nullable Screen parent, Component title, Component description) {
        super(parent, title);
        this.description = description;
    }

    @Override
    public void incAtomic(int maxProgress) {
        if (this.atomicCounter != null) {
            this.m_6952_(100 * this.atomicCounter.incrementAndGet() / maxProgress);
        }
    }

    @Override
    public void resetAtomic() {
        this.m_6952_(0);
        this.atomicCounter = new AtomicInteger(0);
    }

    public boolean m_6913_() {
        return false;
    }

    public Component getProgressComponent() {
        return this.getProgressComponent(this.currentProgress);
    }

    private Component getProgressComponent(int pg) {
        return Component.m_237115_((String)"title.bclib.progress").m_130946_(": " + pg + "%");
    }

    public void m_6309_(Component text) {
        this.m_6307_(text);
    }

    public void m_6308_(Component text) {
        this.m_6307_(text);
        this.m_6952_(0);
    }

    @Override
    public void m_6307_(Component text) {
        this.stageComponent = text;
        if (this.stage != null) {
            this.stage.setText(text);
        }
        if (this.stageRow != null) {
            this.stageRow.reCalculateLayout();
        }
    }

    public void m_6952_(int progress) {
        if (progress != this.currentProgress) {
            this.currentProgress = progress;
            if (this.progressImage != null) {
                this.progressImage.percentage = (float)this.currentProgress / 100.0f;
            }
            if (this.progress != null) {
                this.progress.setText(this.getProgressComponent());
            }
        }
    }

    @Override
    public void m_7730_() {
    }

    protected LayoutComponent<?, ?> createScreen(LayoutComponent<?, ?> content) {
        return content;
    }

    protected LayoutComponent<?, ?> initContent() {
        VerticalStack grid = (VerticalStack)new VerticalStack(ProgressScreen.fill(), ProgressScreen.fill()).setDebugName("grid");
        grid.addFiller();
        grid.add(this.createTitle());
        grid.addSpacer(4);
        HorizontalStack contentRow = (HorizontalStack)((HorizontalStack)grid.addRow(ProgressScreen.fit(), ProgressScreen.fit()).centerHorizontal()).setDebugName("contentRow");
        this.progressImage = new ProgressLogoRender();
        this.progressImage.percentage = (float)this.currentProgress / 100.0f;
        contentRow.add((LayoutComponent)this.progressImage);
        contentRow.addSpacer(8);
        VerticalStack textCol = (VerticalStack)((VerticalStack)contentRow.addColumn(ProgressScreen.fit(), ProgressScreen.fit()).setDebugName("textCol")).centerVertical();
        textCol.addText(ProgressScreen.fit(), ProgressScreen.fit(), this.description);
        textCol.addSpacer(4);
        this.progress = textCol.addText(ProgressScreen.fit(), ProgressScreen.fit(), this.getProgressComponent()).setColor(ColorHelper.GRAY);
        grid.addSpacer(20);
        this.stageRow = grid.addRow(ProgressScreen.fill(), ProgressScreen.fit());
        this.stage = (MultiLineText)this.stageRow.addMultilineText(ProgressScreen.fill(), ProgressScreen.fit(), (Component)(this.stageComponent != null ? this.stageComponent : Component.m_237113_((String)""))).centerHorizontal();
        grid.addFiller();
        return grid;
    }
}

