/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourPlant;
import org.betterx.bclib.blocks.BaseBlockNotFull;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.tools.AddMineableShears;
import org.betterx.bclib.util.LootUtil;

public abstract class UpDownPlantBlock
extends BaseBlockNotFull
implements RenderLayerProvider,
AddMineableShears,
BehaviourPlant {
    private static final VoxelShape SHAPE = UpDownPlantBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public UpDownPlantBlock() {
        this(BehaviourBuilders.createPlant().m_60918_(SoundType.f_56740_));
    }

    public UpDownPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected abstract boolean isTerrain(BlockState var1);

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState down = world.m_8055_(pos.m_7495_());
        BlockState up = world.m_8055_(pos.m_7494_());
        return !(!this.isTerrain(down) && down.m_60734_() != this || !this.isSupport(up, world, pos) && up.m_60734_() != this);
    }

    protected boolean isSupport(BlockState state, LevelReader world, BlockPos pos) {
        return UpDownPlantBlock.m_49863_((LevelReader)world, (BlockPos)pos.m_7494_(), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        ItemStack tool = (ItemStack)builder.m_287261_(LootContextParams.f_81463_);
        if (LootUtil.isCorrectTool((ItemLike)this, state, tool) || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this)});
        }
        return Lists.newArrayList();
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack stack) {
        super.m_6240_(world, player, pos, state, blockEntity, stack);
        world.m_46586_(pos, Blocks.f_50016_, pos.m_7495_());
    }
}

