/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTrapdoorBlock
extends TrapDoorBlock
implements RenderLayerProvider,
BlockModelProvider,
TagProvider,
DropSelfLootProvider<BaseTrapdoorBlock> {
    protected BaseTrapdoorBlock(BlockBehaviour.Properties properties, BlockSetType type) {
        super(properties, type);
    }

    @Override
    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.m_49966_());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(final ResourceLocation resourceLocation, BlockState blockState) {
        final String name = resourceLocation.m_135815_();
        Optional<String> pattern = PatternsHelper.createJson(BasePatterns.BLOCK_TRAPDOOR, (Map<String, String>)new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("%modid%", resourceLocation.m_135827_());
                this.put("%texture%", name);
                this.put("%side%", name.replace("trapdoor", "door_side"));
            }
        });
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_());
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        boolean isTop = blockState.m_61143_((Property)f_57515_) == Half.TOP;
        boolean isOpen = (Boolean)blockState.m_61143_((Property)f_57514_);
        int y = 0;
        int x = isTop && isOpen ? 270 : (isTop ? 180 : (isOpen ? 90 : 0));
        switch ((Direction)blockState.m_61143_((Property)f_54117_)) {
            case EAST: {
                y = isTop && isOpen ? 270 : 90;
                break;
            }
            case NORTH: {
                if (!isTop || !isOpen) break;
                y = 180;
                break;
            }
            case SOUTH: {
                y = isTop && isOpen ? 0 : 180;
                break;
            }
            case WEST: {
                y = isTop && isOpen ? 90 : 270;
                break;
            }
        }
        BlockModelRotation rotation = BlockModelRotation.m_119153_((int)x, (int)y);
        return ModelsHelper.createMultiVariant(modelId, rotation.m_6189_(), false);
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13036_);
        itemTags.add((TagKey<Item>)ItemTags.f_13144_);
    }

    public static BaseTrapdoorBlock from(Block source, BlockSetType type, boolean flammable) {
        return BehaviourHelper.from(source, type, (s, t) -> new Wood((Block)s, (BlockSetType)t, flammable), Stone::new, Metal::new);
    }

    public static class Wood
    extends BaseTrapdoorBlock
    implements BehaviourWood {
        public Wood(Block source, BlockSetType type, boolean flammable) {
            this(BehaviourBuilders.createTrapDoor(source.m_284356_(), flammable).m_60918_(SoundType.f_56736_), type);
        }

        public Wood(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13102_);
            itemTags.add((TagKey<Item>)ItemTags.f_13178_);
        }
    }

    public static class Metal
    extends BaseTrapdoorBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            this(BehaviourBuilders.createTrapDoor(source.m_284356_(), false).m_60918_(SoundType.f_56743_), type);
        }

        public Metal(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }

    public static class Stone
    extends BaseTrapdoorBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            this(BehaviourBuilders.createTrapDoor(source.m_284356_(), false).m_60918_(SoundType.f_56742_), type);
        }

        public Stone(BlockBehaviour.Properties properties, BlockSetType type) {
            super(properties, type);
        }
    }
}

