/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourObsidian;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BasePatterns;
import org.betterx.bclib.client.models.ModelsHelper;
import org.betterx.bclib.client.models.PatternsHelper;
import org.betterx.bclib.interfaces.BlockModelProvider;
import org.betterx.bclib.interfaces.CustomItemProvider;
import org.betterx.bclib.interfaces.TagProvider;
import org.jetbrains.annotations.Nullable;

public abstract class BaseStairsBlock
extends StairBlock
implements BlockModelProvider,
CustomItemProvider,
TagProvider,
DropSelfLootProvider<BaseStairsBlock> {
    private final Block parent;
    public final boolean fireproof;

    protected BaseStairsBlock(Block source, boolean fireproof) {
        super(source.m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)source));
        this.parent = source;
        this.fireproof = fireproof;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BlockModel getItemModel(ResourceLocation resourceLocation) {
        return this.getBlockModel(resourceLocation, this.m_49966_());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    @Nullable
    public BlockModel getBlockModel(ResourceLocation blockId, BlockState blockState) {
        ResourceLocation parentId = BuiltInRegistries.f_256975_.m_7981_((Object)this.parent);
        Optional<String> pattern = PatternsHelper.createJson(switch ((StairsShape)blockState.m_61143_((Property)f_56843_)) {
            default -> throw new IncompatibleClassChangeError();
            case StairsShape.STRAIGHT -> BasePatterns.BLOCK_STAIR;
            case StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> BasePatterns.BLOCK_STAIR_INNER;
            case StairsShape.OUTER_LEFT, StairsShape.OUTER_RIGHT -> BasePatterns.BLOCK_STAIR_OUTER;
        }, parentId);
        return ModelsHelper.fromPattern(pattern);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public UnbakedModel getModelVariant(ResourceLocation stateId, BlockState blockState, Map<ResourceLocation, UnbakedModel> modelCache) {
        StairsShape shape = (StairsShape)blockState.m_61143_((Property)f_56843_);
        String state = switch (shape) {
            case StairsShape.INNER_LEFT, StairsShape.INNER_RIGHT -> "_inner";
            case StairsShape.OUTER_LEFT, StairsShape.OUTER_RIGHT -> "_outer";
            default -> "";
        };
        ResourceLocation modelId = new ResourceLocation(stateId.m_135827_(), "block/" + stateId.m_135815_() + state);
        this.registerBlockModel(stateId, modelId, blockState, modelCache);
        boolean isTop = blockState.m_61143_((Property)f_56842_) == Half.TOP;
        boolean isLeft = shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT;
        boolean isRight = shape == StairsShape.INNER_RIGHT || shape == StairsShape.OUTER_RIGHT;
        int y = 0;
        int x = isTop ? 180 : 0;
        switch ((Direction)blockState.m_61143_((Property)f_56841_)) {
            case NORTH: {
                if (isTop && !isRight) {
                    y = 270;
                    break;
                }
                if (isTop) break;
                y = isLeft ? 180 : 270;
                break;
            }
            case EAST: {
                if (isTop && isRight) {
                    y = 90;
                    break;
                }
                if (isTop || !isLeft) break;
                y = 270;
                break;
            }
            case SOUTH: {
                if (isTop) {
                    y = isRight ? 180 : 90;
                    break;
                }
                if (isLeft) break;
                y = 90;
                break;
            }
            default: {
                y = isTop && isRight ? 270 : (!isTop && isLeft ? 90 : 180);
            }
        }
        BlockModelRotation rotation = BlockModelRotation.m_119153_((int)x, (int)y);
        return ModelsHelper.createMultiVariant(modelId, rotation.m_6189_(), true);
    }

    @Override
    public BlockItem getCustomItem(ResourceLocation blockID, Item.Properties settings) {
        if (this.fireproof) {
            settings = settings.m_41486_();
        }
        return new BlockItem((Block)this, settings);
    }

    @Override
    public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
        blockTags.add((TagKey<Block>)BlockTags.f_13030_);
        itemTags.add((TagKey<Item>)ItemTags.f_13138_);
    }

    public static BaseStairsBlock from(Block source, boolean flammable) {
        return BehaviourHelper.from(source, block -> new Wood((Block)block, flammable), block -> new Stone((Block)block, !flammable), block -> new Metal((Block)block, !flammable), block -> new Obsidian((Block)block, !flammable), null);
    }

    public static class Obsidian
    extends BaseStairsBlock
    implements BehaviourObsidian {
        public Obsidian(Block source) {
            this(source, true);
        }

        public Obsidian(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Metal
    extends BaseStairsBlock
    implements BehaviourMetal {
        public Metal(Block source) {
            this(source, true);
        }

        public Metal(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Stone
    extends BaseStairsBlock
    implements BehaviourStone {
        public Stone(Block source) {
            this(source, true);
        }

        public Stone(Block source, boolean fireproof) {
            super(source, fireproof);
        }
    }

    public static class Wood
    extends BaseStairsBlock
    implements BehaviourWood {
        public Wood(Block source) {
            this(source, false);
        }

        public Wood(Block source, boolean fireproof) {
            super(source, fireproof);
        }

        @Override
        public void addTags(List<TagKey<Block>> blockTags, List<TagKey<Item>> itemTags) {
            super.addTags(blockTags, itemTags);
            blockTags.add((TagKey<Block>)BlockTags.f_13096_);
            itemTags.add((TagKey<Item>)ItemTags.f_13174_);
        }
    }
}

