/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.registry.BaseBlockEntities;

public class BaseBarrelBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> inventory;
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos blockPos, BlockState blockState) {
            BaseBarrelBlockEntity.this.playSound(blockState, SoundEvents.f_11725_);
            BaseBarrelBlockEntity.this.updateBlockState(blockState, true);
        }

        protected void m_142289_(Level level, BlockPos blockPos, BlockState blockState) {
            BaseBarrelBlockEntity.this.playSound(blockState, SoundEvents.f_11724_);
            BaseBarrelBlockEntity.this.updateBlockState(blockState, false);
        }

        protected void m_142148_(Level level, BlockPos blockPos, BlockState blockState, int i, int j) {
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof ChestMenu) {
                Container container = ((ChestMenu)player.f_36096_).m_39261_();
                return container == BaseBarrelBlockEntity.this;
            }
            return false;
        }
    };

    private BaseBarrelBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    }

    public BaseBarrelBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(BaseBlockEntities.BARREL, blockPos, blockState);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        }
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.barrel");
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return ChestMenu.m_39237_((int)syncId, (Inventory)playerInventory, (Container)this);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    private void scheduleUpdate() {
        this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), 5);
    }

    public void tick() {
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    private void updateBlockState(BlockState state, boolean open) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)BarrelBlock.f_49043_, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void playSound(BlockState blockState, SoundEvent soundEvent) {
        if (this.f_58857_ != null) {
            Vec3i facingDir = ((Direction)blockState.m_61143_((Property)BarrelBlock.f_49042_)).m_122436_();
            double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)facingDir.m_123341_() / 2.0;
            double y = (double)this.f_58858_.m_123342_() + 0.5 + (double)facingDir.m_123342_() / 2.0;
            double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)facingDir.m_123343_() / 2.0;
            this.f_58857_.m_6263_(null, x, y, z, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }
}

