/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.behaviours;

import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class BehaviourBuilders {
    public static BlockBehaviour.Properties createPlant() {
        return BehaviourBuilders.createPlant(MapColor.f_283915_);
    }

    public static BlockBehaviour.Properties createPlant(MapColor color) {
        return BehaviourBuilders.createWalkablePlant(color).m_60910_();
    }

    public static BlockBehaviour.Properties createWalkablePlant() {
        return BehaviourBuilders.createWalkablePlant(MapColor.f_283915_);
    }

    public static BlockBehaviour.Properties createWalkablePlant(MapColor color) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60955_().m_60966_().m_60918_(SoundType.f_56740_).m_278166_(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties createVine() {
        return BehaviourBuilders.createVine(MapColor.f_283915_);
    }

    public static Item.Properties createDisc() {
        return new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE);
    }

    public static BlockBehaviour.Properties createStaticVine(MapColor color) {
        return BehaviourBuilders.createPlant(color).m_280170_().m_60910_().m_60978_(0.2f).m_60918_(SoundType.f_56760_);
    }

    public static BlockBehaviour.Properties createVine(MapColor color) {
        return BehaviourBuilders.createStaticVine(color).m_60977_();
    }

    public static BlockBehaviour.Properties createGrass(MapColor color) {
        return BehaviourBuilders.createPlant(color).m_60910_().m_60955_().m_222979_(BlockBehaviour.OffsetType.XZ).m_60918_(SoundType.f_56740_);
    }

    public static BlockBehaviour.Properties createSeed(MapColor color) {
        return BehaviourBuilders.createPlant(color).m_60910_().m_60977_().m_60918_(SoundType.f_56759_).m_222979_(BlockBehaviour.OffsetType.XZ);
    }

    public static BlockBehaviour.Properties createPlantCover(MapColor color) {
        return BehaviourBuilders.createPlant(color).m_280606_().m_60910_().m_280170_().m_60978_(0.2f).m_60918_(SoundType.f_154676_);
    }

    public static BlockBehaviour.Properties createWaterPlant() {
        return BehaviourBuilders.createWaterPlant(MapColor.f_283864_);
    }

    public static BlockBehaviour.Properties createWaterPlant(MapColor color) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60966_().m_60955_().m_60910_().m_60918_(SoundType.f_56752_).m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY);
    }

    public static BlockBehaviour.Properties createReplaceableWaterPlant() {
        return BehaviourBuilders.createWaterPlant().m_280170_();
    }

    public static BlockBehaviour.Properties createLeaves() {
        return BehaviourBuilders.createLeaves(MapColor.f_283915_, true);
    }

    public static BlockBehaviour.Properties createStaticLeaves() {
        return BehaviourBuilders.createStaticLeaves(MapColor.f_283915_, true);
    }

    public static BlockBehaviour.Properties createStaticLeaves(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60978_(0.2f).m_60955_().m_60922_(Blocks::m_50821_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_).m_278166_(PushReaction.DESTROY).m_60924_(Blocks::m_50805_).m_60918_(SoundType.f_56740_);
        if (flammable) {
            p.m_278183_();
        }
        return p;
    }

    public static BlockBehaviour.Properties createLeaves(MapColor color, boolean flammable) {
        return BehaviourBuilders.createStaticLeaves(color, flammable).m_60977_();
    }

    public static BlockBehaviour.Properties createCactus(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60977_().m_60978_(0.4f).m_60918_(SoundType.f_56745_).m_278166_(PushReaction.DESTROY).m_60955_();
        if (flammable) {
            p.m_278183_();
        }
        return p;
    }

    public static BlockBehaviour.Properties createMetal() {
        return BehaviourBuilders.createMetal(MapColor.f_283906_);
    }

    public static BlockBehaviour.Properties createMetal(MapColor color) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280658_(NoteBlockInstrument.IRON_XYLOPHONE).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_);
    }

    public static BlockBehaviour.Properties createStone() {
        return BehaviourBuilders.createStone(MapColor.f_283947_);
    }

    public static BlockBehaviour.Properties createStone(MapColor color) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60913_(1.5f, 6.0f).m_280658_(NoteBlockInstrument.BASEDRUM);
    }

    public static BlockBehaviour.Properties createWood() {
        return BehaviourBuilders.createWood(MapColor.f_283825_, true);
    }

    public static BlockBehaviour.Properties createWood(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f).m_60918_(SoundType.f_56736_);
        if (flammable) {
            p.m_278183_();
        }
        return p;
    }

    public static BlockBehaviour.Properties createSign(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f);
        if (flammable) {
            p.m_278183_();
        }
        return p;
    }

    public static BlockBehaviour.Properties createWallSign(MapColor color, Block dropBlock, boolean flammable) {
        return BehaviourBuilders.createSign(color, flammable).m_60916_(dropBlock);
    }

    public static BlockBehaviour.Properties createTrapDoor(MapColor color, boolean flammable) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_284310_().m_284180_(color).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_60922_(Blocks::m_50778_);
        if (flammable) {
            p.m_278183_();
        }
        return p;
    }

    public static BlockBehaviour.Properties createGlass() {
        return BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.HAT).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_(Blocks::m_50778_).m_60924_(Blocks::m_50805_).m_60960_(Blocks::m_50805_).m_60971_(Blocks::m_50805_);
    }

    public static BlockBehaviour.Properties createSnow() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283811_).m_60999_().m_60978_(0.2f).m_60918_(SoundType.f_56747_);
    }
}

