/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v3.levelgen.features.BCLConfigureFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLPlacedFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.config.ConditionFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.PillarFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.PlaceFacingBlockConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.SequenceFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.config.TemplateFeatureConfig;
import org.betterx.bclib.api.v3.levelgen.features.features.ConditionFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.MarkPostProcessingFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.PillarFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.PlaceBlockFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.SequenceFeature;
import org.betterx.bclib.api.v3.levelgen.features.features.TemplateFeature;
import org.jetbrains.annotations.ApiStatus;

public class BCLFeature<F extends Feature<FC>, FC extends FeatureConfiguration> {
    public static final Feature<PlaceFacingBlockConfig> PLACE_BLOCK = BCLFeature.register(BCLib.makeID("place_block"), new PlaceBlockFeature<PlaceFacingBlockConfig>(PlaceFacingBlockConfig.CODEC));
    public static final Feature<TemplateFeatureConfig> TEMPLATE = BCLFeature.register(BCLib.makeID("template"), new TemplateFeature<TemplateFeatureConfig>(TemplateFeatureConfig.CODEC));
    public static final Feature<NoneFeatureConfiguration> MARK_POSTPROCESSING = BCLFeature.register(BCLib.makeID("mark_postprocessing"), new MarkPostProcessingFeature());
    public static final Feature<SequenceFeatureConfig> SEQUENCE = BCLFeature.register(BCLib.makeID("sequence"), new SequenceFeature());
    public static final Feature<ConditionFeatureConfig> CONDITION = BCLFeature.register(BCLib.makeID("condition"), new ConditionFeature());
    public static final Feature<PillarFeatureConfig> PILLAR = BCLFeature.register(BCLib.makeID("pillar"), new PillarFeature());
    public final BCLConfigureFeature<F, FC> configuredFeature;
    public final Holder<PlacedFeature> placedFeature;
    public final GenerationStep.Decoration decoration;

    @ApiStatus.Internal
    BCLFeature(BCLConfigureFeature<F, FC> configuredFeature, Holder<PlacedFeature> placed, GenerationStep.Decoration decoration) {
        this.configuredFeature = configuredFeature;
        this.placedFeature = placed;
        this.decoration = decoration;
    }

    public F getFeature() {
        return this.configuredFeature.getFeature();
    }

    public Holder<PlacedFeature> getPlacedFeature() {
        return this.placedFeature;
    }

    public GenerationStep.Decoration getDecoration() {
        return this.decoration;
    }

    public FC getConfiguration() {
        return this.configuredFeature.getConfiguration();
    }

    public static <C extends FeatureConfiguration, F extends Feature<C>> F register(ResourceLocation location, F feature) {
        return (F)((Feature)Registry.m_122965_((Registry)BuiltInRegistries.f_256810_, (ResourceLocation)location, feature));
    }

    public BCLFeature<F, FC> register(BootstapContext<PlacedFeature> bootstrapContext) {
        return this;
    }

    public static class Unregistered<F extends Feature<FC>, FC extends FeatureConfiguration>
    extends BCLFeature<F, FC> {
        private BCLFeature<F, FC> registered = null;

        Unregistered(BCLConfigureFeature<F, FC> configuredFeature, Holder<PlacedFeature> placed, GenerationStep.Decoration decoration) {
            super(configuredFeature, placed, decoration);
        }

        @Override
        public BCLFeature<F, FC> register(BootstapContext<PlacedFeature> bootstrapContext) {
            if (this.registered != null) {
                return this.registered;
            }
            Holder<PlacedFeature> holder = BCLPlacedFeatureBuilder.register(bootstrapContext, this.getPlacedFeature());
            BCLPlacedFeatureBuilder.UNBOUND_FEATURES.remove(this);
            this.registered = new BCLFeature(this.configuredFeature, holder, this.decoration);
            return this.registered;
        }
    }
}

