/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.surface;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleEntry;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.api.v2.levelgen.surface.rules.NoiseCondition;

public class SurfaceRuleBuilder {
    private static final Map<String, SurfaceRuleEntry> RULES_CACHE = Maps.newHashMap();
    private static final SurfaceRuleBuilder INSTANCE = new SurfaceRuleBuilder();
    private final List<SurfaceRuleEntry> rules = Lists.newArrayList();
    private SurfaceRuleEntry entryInstance;
    private ResourceKey<Biome> biomeKey;

    private SurfaceRuleBuilder() {
    }

    public static SurfaceRuleBuilder start() {
        SurfaceRuleBuilder.INSTANCE.biomeKey = null;
        SurfaceRuleBuilder.INSTANCE.rules.clear();
        return INSTANCE;
    }

    public SurfaceRuleBuilder biome(ResourceKey<Biome> biomeKey) {
        this.biomeKey = biomeKey;
        return this;
    }

    public SurfaceRuleBuilder biome(Biome biome) {
        return this.biome((ResourceKey<Biome>)BiomeAPI.getBiomeKey(biome));
    }

    public SurfaceRuleBuilder surface(BlockState state) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("surface_" + state.toString(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189390_((BlockState)state);
            rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)rule);
            return new SurfaceRuleEntry(2, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder subsurface(BlockState state, int depth) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("subsurface_" + depth + "_" + state.toString(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189390_((BlockState)state);
            rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202176_((int)depth, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)rule);
            return new SurfaceRuleEntry(3, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder filler(BlockState state) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("fill_" + state.toString(), () -> new SurfaceRuleEntry(10, SurfaceRules.m_189390_((BlockState)state)));
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder floor(BlockState state) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("floor_" + state.toString(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189390_((BlockState)state);
            return new SurfaceRuleEntry(3, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)rule));
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder belowFloor(BlockState state, int height, NoiseCondition noise) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("below_floor_" + height + "_" + state.toString() + "_" + noise.getClass().getSimpleName(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189390_((BlockState)state);
            rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202176_((int)height, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)noise, (SurfaceRules.RuleSource)rule));
            return new SurfaceRuleEntry(3, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder belowFloor(BlockState state, int height) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("below_floor_" + height + "_" + state.toString(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189390_((BlockState)state);
            rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202176_((int)height, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)rule);
            return new SurfaceRuleEntry(3, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder ceil(BlockState state) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("ceil_" + state.toString(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189390_((BlockState)state);
            return new SurfaceRuleEntry(3, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)rule));
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder aboveCeil(BlockState state, int height) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("above_ceil_" + height + "_" + state.toString(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189390_((BlockState)state);
            rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202176_((int)height, (boolean)false, (CaveSurface)CaveSurface.CEILING), (SurfaceRules.RuleSource)rule);
            return new SurfaceRuleEntry(3, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder steep(BlockState state, int depth) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("steep_" + depth + "_" + state.toString(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189390_((BlockState)state);
            rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_202176_((int)depth, (boolean)false, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)rule);
            rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189381_(), (SurfaceRules.RuleSource)rule);
            int priority = depth < 1 ? 0 : 1;
            return new SurfaceRuleEntry(priority, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder rule(int priority, SurfaceRules.RuleSource rule) {
        this.rules.add(new SurfaceRuleEntry(priority, rule));
        return this;
    }

    public SurfaceRuleBuilder rule(SurfaceRules.RuleSource rule) {
        return this.rule(7, rule);
    }

    public SurfaceRuleBuilder chancedFloor(BlockState surfaceBlockA, BlockState surfaceBlockB) {
        return this.chancedFloor(surfaceBlockA, surfaceBlockB, (NoiseCondition)Conditions.DOUBLE_BLOCK_SURFACE_NOISE);
    }

    public SurfaceRuleBuilder chancedFloor(BlockState surfaceBlockA, BlockState surfaceBlockB, NoiseCondition noise) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("chancedFloor_" + surfaceBlockA + "_" + surfaceBlockB + "_" + noise.getClass().getSimpleName(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)noise, (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)surfaceBlockA)), SurfaceRules.m_189390_((BlockState)surfaceBlockB)}));
            return new SurfaceRuleEntry(4, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRuleBuilder chancedFloor(BlockState surfaceBlockA, SurfaceRules.RuleSource surfaceBlockB, NoiseCondition noise) {
        this.entryInstance = SurfaceRuleBuilder.getFromCache("chancedFloor_" + surfaceBlockA + "_" + surfaceBlockB + "_" + noise.getClass().getSimpleName(), () -> {
            SurfaceRules.RuleSource rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)noise, (SurfaceRules.RuleSource)SurfaceRules.m_189390_((BlockState)surfaceBlockA)), surfaceBlockB}));
            return new SurfaceRuleEntry(4, rule);
        });
        this.rules.add(this.entryInstance);
        return this;
    }

    public SurfaceRules.RuleSource build() {
        Collections.sort(this.rules);
        List<SurfaceRules.RuleSource> ruleList = this.rules.stream().map(entry -> entry.getRule()).toList();
        SurfaceRules.RuleSource[] ruleArray = ruleList.toArray(new SurfaceRules.RuleSource[ruleList.size()]);
        SurfaceRules.RuleSource rule = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])ruleArray);
        if (this.biomeKey != null) {
            rule = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{this.biomeKey}), (SurfaceRules.RuleSource)rule);
        }
        return rule;
    }

    private static SurfaceRuleEntry getFromCache(String name, Supplier<SurfaceRuleEntry> supplier) {
        SurfaceRuleEntry entry = RULES_CACHE.get(name);
        if (entry == null) {
            entry = supplier.get();
            RULES_CACHE.put(name, entry);
        }
        return entry;
    }
}

