/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.structures;

import com.google.common.collect.Maps;
import dev.su5ed.sinytra.connector.mod.ConnectorMod;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.betterx.bclib.BCLib;
import org.jetbrains.annotations.Nullable;

public class StructureNBT {
    public final ResourceLocation location;
    protected StructureTemplate structure;
    private static final Map<ResourceLocation, StructureNBT> STRUCTURE_CACHE = Maps.newHashMap();
    private static final Map<ResourceLocation, StructureTemplate> READER_CACHE = Maps.newHashMap();

    protected StructureNBT(ResourceLocation location) {
        this.location = location;
        this.structure = StructureNBT.readStructureFromJar(location);
    }

    protected StructureNBT(ResourceLocation location, StructureTemplate structure) {
        this.location = location;
        this.structure = structure;
    }

    public static Rotation getRandomRotation(RandomSource random) {
        return Rotation.m_221990_((RandomSource)random);
    }

    public static Mirror getRandomMirror(RandomSource random) {
        return Mirror.values()[random.m_188503_(3)];
    }

    public static StructureNBT create(ResourceLocation location) {
        return STRUCTURE_CACHE.computeIfAbsent(location, r -> new StructureNBT((ResourceLocation)r));
    }

    public boolean generateCentered(ServerLevelAccessor world, BlockPos pos, Rotation rotation, Mirror mirror) {
        BlockPos newPos = this.getCenteredPos(pos, rotation, mirror);
        if (newPos == null) {
            return false;
        }
        StructurePlaceSettings data = new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror);
        this.structure.m_230328_(world, newPos, newPos, data, world.m_213780_(), 18);
        return true;
    }

    public boolean generateAt(ServerLevelAccessor world, BlockPos pos, Rotation rotation, Mirror mirror) {
        StructurePlaceSettings data = new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror);
        this.structure.m_230328_(world, pos, pos, data, world.m_213780_(), 18);
        return true;
    }

    @Nullable
    private BlockPos getCenteredPos(BlockPos pos, Rotation rotation, Mirror mirror) {
        if (this.structure == null) {
            BCLib.LOGGER.error("No structure: " + this.location.toString());
            return null;
        }
        BlockPos.MutableBlockPos blockpos2 = new BlockPos.MutableBlockPos().m_122190_(this.structure.m_163801_());
        if (mirror == Mirror.FRONT_BACK) {
            blockpos2.m_142451_(-blockpos2.m_123341_());
        }
        if (mirror == Mirror.LEFT_RIGHT) {
            blockpos2.m_142443_(-blockpos2.m_123343_());
        }
        blockpos2.m_122190_((Vec3i)blockpos2.m_7954_(rotation));
        return pos.m_7918_(-blockpos2.m_123341_() >> 1, 0, -blockpos2.m_123343_() >> 1);
    }

    private static StructureTemplate readStructureFromJar(ResourceLocation resource) {
        return READER_CACHE.computeIfAbsent(resource, r -> StructureNBT._readStructureFromJar(r));
    }

    private static String getStructurePath(ResourceLocation resource) {
        return "data/" + resource.m_135827_() + "/structures/" + resource.m_135815_();
    }

    private static StructureTemplate _readStructureFromJar(ResourceLocation resource) {
        try {
            InputStream inputstream = ConnectorMod.getModResourceAsStream(MinecraftServer.class, (String)("/" + StructureNBT.getStructurePath(resource) + ".nbt"));
            return StructureNBT.readStructureFromStream(inputstream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<StructureNBT> createResourcesFrom(ResourceLocation resource, int recursionDepth) {
        String ns = resource.m_135827_();
        String nm = resource.m_135815_();
        String resourceFolder = StructureNBT.getStructurePath(resource);
        URL url = MinecraftServer.class.getClassLoader().getResource(resourceFolder);
        if (url != null) {
            Path myPath;
            URI uri;
            try {
                uri = url.toURI();
            }
            catch (URISyntaxException e) {
                BCLib.LOGGER.error("Unable to load Resources: ", e);
                return null;
            }
            if (uri.getScheme().equals("jar")) {
                FileSystem fileSystem = null;
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (FileSystemNotFoundException notLoaded) {
                    try {
                        fileSystem = FileSystems.newFileSystem(uri, new HashMap());
                    }
                    catch (IOException e) {
                        BCLib.LOGGER.error("Unable to load Filesystem: ", e);
                        return null;
                    }
                }
                myPath = fileSystem.getPath(resourceFolder, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            if (Files.isDirectory(myPath, new LinkOption[0])) {
                try {
                    return Files.walk(myPath, recursionDepth <= 0 ? Integer.MAX_VALUE : recursionDepth, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0])).map(p -> {
                        if (p.isAbsolute()) {
                            return Path.of(uri).relativize((Path)p).toString();
                        }
                        return p.toString().replace(resourceFolder, "").replaceAll("^/+", "");
                    }).filter(s -> s.endsWith(".nbt")).map(s -> new ResourceLocation(ns, (String)(nm.isEmpty() ? "" : nm + "/") + s.substring(0, s.length() - 4))).sorted(Comparator.comparing(ResourceLocation::toString)).map(r -> {
                        BCLib.LOGGER.info("Loading Structure: " + r);
                        try {
                            return StructureNBT.create(r);
                        }
                        catch (Exception e) {
                            BCLib.LOGGER.error("Unable to load Structure " + r, e);
                            return null;
                        }
                    }).toList();
                }
                catch (IOException e) {
                    BCLib.LOGGER.error("Unable to load Resources: ", e);
                    return null;
                }
            }
        }
        return null;
    }

    private static StructureTemplate readStructureFromStream(InputStream stream) throws IOException {
        CompoundTag nbttagcompound = NbtIo.m_128939_((InputStream)stream);
        StructureTemplate template = new StructureTemplate();
        template.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), nbttagcompound);
        return template;
    }

    public BlockPos getSize(Rotation rotation) {
        if (rotation == Rotation.NONE || rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(this.structure.m_163801_());
        }
        Vec3i size = this.structure.m_163801_();
        int x = size.m_123341_();
        int z = size.m_123343_();
        return new BlockPos(z, size.m_123342_(), x);
    }

    public String getName() {
        return this.location.m_135815_();
    }

    public BoundingBox getBoundingBox(BlockPos pos, Rotation rotation, Mirror mirror) {
        return this.structure.m_74633_(new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror), pos);
    }

    public BoundingBox getCenteredBoundingBox(BlockPos pos, Rotation rotation, Mirror mirror) {
        return this.structure.m_74633_(new StructurePlaceSettings().m_74379_(rotation).m_74377_(mirror), this.getCenteredPos(pos, rotation, mirror));
    }
}

