/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeData;
import org.betterx.bclib.util.WeightedList;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class BCLBiome
implements BiomeData {
    public static final Codec<BCLBiome> CODEC = RecordCodecBuilder.create(instance -> BCLBiome.codecWithSettings(instance).apply((Applicative)instance, BCLBiome::new));
    public static final KeyDispatchDataCodec<? extends BCLBiome> KEY_CODEC = KeyDispatchDataCodec.m_216236_(CODEC);
    public final BCLBiomeSettings settings;
    private final Map<String, Object> customData = Maps.newHashMap();
    private final ResourceLocation biomeID;
    private final ResourceKey<Biome> biomeKey;
    protected final List<Climate.ParameterPoint> parameterPoints = Lists.newArrayList();
    private ResourceLocation biomeParent;
    private ResourceLocation edge;
    private BiomeAPI.BiomeType intendedType = BiomeAPI.BiomeType.NONE;
    private final boolean didLoadConfig = false;
    @ApiStatus.Internal
    private Biome biomeToRegister;

    @Override
    public KeyDispatchDataCodec<? extends BCLBiome> codec() {
        return KEY_CODEC;
    }

    public static <T extends BCLBiome, P11> Products.P11<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<ResourceLocation>, ResourceLocation, Optional<List<Climate.ParameterPoint>>, Optional<ResourceLocation>, Optional<String>, P11> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P11> p11) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10, p11);
    }

    public static <T extends BCLBiome, P11, P12> Products.P12<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<ResourceLocation>, ResourceLocation, Optional<List<Climate.ParameterPoint>>, Optional<ResourceLocation>, Optional<String>, P11, P12> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10, p11, p12);
    }

    public static <T extends BCLBiome, P11, P12, P13, P14> Products.P14<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<ResourceLocation>, ResourceLocation, Optional<List<Climate.ParameterPoint>>, Optional<ResourceLocation>, Optional<String>, P11, P12, P13, P14> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10, p11, p12, p13, p14);
    }

    public static <T extends BCLBiome, P11, P12, P13> Products.P13<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<ResourceLocation>, ResourceLocation, Optional<List<Climate.ParameterPoint>>, Optional<ResourceLocation>, Optional<String>, P11, P12, P13> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P11> p11, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10, p11, p12, p13);
    }

    public static <T extends BCLBiome> Products.P10<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<ResourceLocation>, ResourceLocation, Optional<List<Climate.ParameterPoint>>, Optional<ResourceLocation>, Optional<String>> codecWithSettings(RecordCodecBuilder.Instance<T> instance) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t10);
    }

    protected BCLBiome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<ResourceLocation> edge, ResourceLocation biomeID, Optional<List<Climate.ParameterPoint>> parameterPoints, Optional<ResourceLocation> biomeParent, Optional<String> intendedType) {
        this.settings = new BCLBiomeSettings(terrainHeight, fogDensity, genChance, edgeSize, vertical);
        this.edge = edge.orElse(null);
        this.biomeID = biomeID;
        this.biomeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeID);
        this.biomeParent = biomeParent.orElse(null);
        if (parameterPoints.isPresent()) {
            this.parameterPoints.addAll((Collection<Climate.ParameterPoint>)parameterPoints.get());
        }
        this.setIntendedType(intendedType.map(t -> BiomeAPI.BiomeType.create(t)).orElse(BiomeAPI.BiomeType.NONE));
    }

    protected BCLBiome(ResourceKey<Biome> biomeKey) {
        this(biomeKey.m_135782_());
    }

    protected BCLBiome(ResourceLocation biomeID) {
        this((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeID), null);
    }

    @ApiStatus.Internal
    public BCLBiome(ResourceLocation biomeID, BiomeAPI.BiomeType type) {
        this((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeID), (BCLBiomeSettings)null);
        this.setIntendedType(type);
    }

    protected BCLBiome(ResourceKey<Biome> biomeKey, BCLBiomeSettings defaults) {
        this.settings = defaults == null ? new BCLBiomeSettings() : defaults;
        this.biomeID = biomeKey.m_135782_();
        this.biomeKey = biomeKey;
    }

    protected BCLBiome(ResourceLocation biomeID, BCLBiomeSettings defaults) {
        this.settings = defaults == null ? new BCLBiomeSettings() : defaults;
        this.biomeID = biomeID;
        this.biomeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeID);
    }

    protected BCLBiome setIntendedType(BiomeAPI.BiomeType type) {
        return this._setIntendedType(type);
    }

    BCLBiome _setIntendedType(BiomeAPI.BiomeType type) {
        this.intendedType = type;
        return this;
    }

    public BiomeAPI.BiomeType getIntendedType() {
        return this.intendedType;
    }

    @Nullable
    public BCLBiome getEdge() {
        return BiomeAPI.getBiome(this.edge);
    }

    public boolean hasEdge() {
        return !BCLBiomeRegistry.isEmptyBiome(this.edge);
    }

    BCLBiome _setEdge(BCLBiome edge) {
        if (edge != null) {
            this.edge = edge.biomeID;
            edge.biomeParent = this.biomeID;
        } else {
            this.edge = null;
        }
        return this;
    }

    public BCLBiome addEdge(BCLBiome newEdge) {
        if (this.edge != null) {
            newEdge.biomeParent = this.edge;
        } else {
            this._setEdge(newEdge);
        }
        return this;
    }

    public BCLBiome addSubBiome(BCLBiome biome) {
        biome.biomeParent = this.biomeID;
        return this;
    }

    private WeightedList<BCLBiome> getSubBiomes() {
        RegistryAccess acc = WorldBootstrap.getLastRegistryAccess();
        WeightedList<BCLBiome> subbiomes = new WeightedList<BCLBiome>();
        subbiomes.add(this, 1.0f);
        if (acc == null) {
            return subbiomes;
        }
        MappedRegistry<BCLBiome> reg = acc.m_6632_(BCLBiomeRegistry.BCL_BIOMES_REGISTRY).orElse(null);
        if (reg == null) {
            reg = BCLBiomeRegistry.BUILTIN_BCL_BIOMES;
        }
        for (Map.Entry entry : reg.m_6579_()) {
            BCLBiome b = (BCLBiome)entry.getValue();
            if (!this.biomeID.equals((Object)((BCLBiome)entry.getValue()).biomeParent) || ((BCLBiome)entry.getValue()).isEdgeBiome()) continue;
            subbiomes.add(b, b.settings.genChance);
        }
        return subbiomes;
    }

    public void forEachSubBiome(BiConsumer<BCLBiome, Float> consumer) {
        WeightedList<BCLBiome> subbiomes = this.getSubBiomes();
        for (int i = 0; i < subbiomes.size(); ++i) {
            consumer.accept(subbiomes.get(i), Float.valueOf(subbiomes.getWeight(i)));
        }
    }

    @Nullable
    public BCLBiome getParentBiome() {
        return BiomeAPI.getBiome(this.biomeParent);
    }

    public boolean hasParentBiome() {
        return !BCLBiomeRegistry.isEmptyBiome(this.biomeParent);
    }

    public boolean isSame(BCLBiome biome) {
        return biome == this || biome.biomeParent != null && biome.biomeParent.equals((Object)this.biomeID);
    }

    public ResourceLocation getID() {
        return this.biomeID;
    }

    public ResourceKey<Biome> getBiomeKey() {
        return this.biomeKey;
    }

    public ResourceKey<BCLBiome> getBCLBiomeKey() {
        return ResourceKey.m_135785_(BCLBiomeRegistry.BCL_BIOMES_REGISTRY, (ResourceLocation)this.biomeID);
    }

    void afterRegistration() {
    }

    public boolean is(ResourceKey<Biome> key) {
        return this.biomeID.equals((Object)key.m_135782_());
    }

    public boolean is(ResourceLocation loc) {
        return this.biomeID.equals((Object)loc);
    }

    public boolean is(BCLBiome biome) {
        if (biome == null) {
            return false;
        }
        return this.biomeID.equals((Object)biome.biomeID);
    }

    public boolean equals(ResourceKey<Biome> key) {
        return this.is(key);
    }

    public boolean equals(ResourceLocation loc) {
        return this.is(loc);
    }

    public boolean equals(BCLBiome biome) {
        return this.is(biome);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BCLBiome) {
            BCLBiome biome = (BCLBiome)obj;
            return this.is(biome);
        }
        if (obj instanceof ResourceKey) {
            ResourceKey key = (ResourceKey)obj;
            return this.is((ResourceKey<Biome>)key);
        }
        if (obj instanceof ResourceLocation) {
            ResourceLocation loc = (ResourceLocation)obj;
            return this.is(loc);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.biomeID.hashCode();
    }

    public String toString() {
        return this.biomeID.toString();
    }

    void addClimateParameters(List<Climate.ParameterPoint> params) {
        this.parameterPoints.addAll(params);
    }

    public void forEachClimateParameter(Consumer<Climate.ParameterPoint> consumer) {
        this.parameterPoints.forEach(consumer);
    }

    public String configGroup() {
        return this.biomeID.m_135827_() + "." + this.biomeID.m_135815_();
    }

    public boolean isEdgeBiome() {
        BCLBiome parent = this.getParentBiome();
        if (parent == null) {
            return false;
        }
        return this.biomeID.equals((Object)parent.edge);
    }

    boolean allowFabricRegistration() {
        return !this.isEdgeBiome();
    }

    @ApiStatus.Internal
    void _setBiomeToRegister(Biome b) {
        this.biomeToRegister = b;
    }

    @ApiStatus.Internal
    Biome _getBiomeToRegister() {
        return this.biomeToRegister;
    }

    @ApiStatus.Internal
    boolean _hasBiomeToRegister() {
        return this.biomeToRegister != null;
    }

    private static class CodecAttributes<T extends BCLBiome> {
        public RecordCodecBuilder<T, Float> t0 = Codec.FLOAT.fieldOf("terrainHeight").orElse((Object)Float.valueOf(0.1f)).forGetter(o1 -> Float.valueOf(o1.settings.terrainHeight));
        public RecordCodecBuilder<T, Float> t1 = Codec.FLOAT.fieldOf("fogDensity").orElse((Object)Float.valueOf(1.0f)).forGetter(o1 -> Float.valueOf(o1.settings.fogDensity));
        public RecordCodecBuilder<T, Float> t2 = Codec.FLOAT.fieldOf("genChance").orElse((Object)Float.valueOf(1.0f)).forGetter(o1 -> Float.valueOf(o1.settings.genChance));
        public RecordCodecBuilder<T, Integer> t3 = Codec.INT.fieldOf("edgeSize").orElse((Object)0).forGetter(o1 -> o1.settings.edgeSize);
        public RecordCodecBuilder<T, Boolean> t4 = Codec.BOOL.fieldOf("vertical").orElse((Object)false).forGetter(o1 -> o1.settings.vertical);
        public RecordCodecBuilder<T, Optional<ResourceLocation>> t5 = ResourceLocation.f_135803_.optionalFieldOf("edge").orElse(Optional.empty()).forGetter(o1 -> o1.edge == null ? Optional.empty() : Optional.of(o1.edge));
        public RecordCodecBuilder<T, ResourceLocation> t6 = ResourceLocation.f_135803_.fieldOf("biome").forGetter(o -> o.biomeID);
        public RecordCodecBuilder<T, Optional<List<Climate.ParameterPoint>>> t7 = Climate.ParameterPoint.f_186862_.listOf().optionalFieldOf("parameter_points").orElse(Optional.of(List.of())).forGetter(o -> o.parameterPoints == null || o.parameterPoints.isEmpty() ? Optional.empty() : Optional.of(o.parameterPoints));
        public RecordCodecBuilder<T, Optional<ResourceLocation>> t8 = ResourceLocation.f_135803_.optionalFieldOf("parent").orElse(Optional.empty()).forGetter(o1 -> o1.biomeParent == null ? Optional.empty() : Optional.of(o1.biomeParent));
        public RecordCodecBuilder<T, Optional<String>> t10 = Codec.STRING.optionalFieldOf("intended_for").orElse(Optional.of(BiomeAPI.BiomeType.NONE.getName())).forGetter(o -> o.intendedType == null ? Optional.empty() : Optional.of(o.intendedType.getName()));

        private CodecAttributes() {
        }
    }
}

