/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen;

import com.mojang.serialization.Lifecycle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLChunkGenerator;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.BCLibNetherBiomeSource;
import org.betterx.bclib.api.v2.generator.config.BCLEndBiomeSourceConfig;
import org.betterx.bclib.api.v2.generator.config.BCLNetherBiomeSourceConfig;
import org.betterx.bclib.registry.PresetsRegistry;
import org.betterx.worlds.together.levelgen.WorldGenUtil;
import org.betterx.worlds.together.util.ModUtil;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;
import org.jetbrains.annotations.NotNull;

public class LevelGenUtil {
    private static final String TAG_VERSION = "version";
    private static final String TAG_BN_GEN_VERSION = "generator_version";

    @NotNull
    public static LevelStem getBCLNetherLevelStem(WorldGenUtil.Context context, BCLNetherBiomeSourceConfig config) {
        BCLibNetherBiomeSource netherSource = new BCLibNetherBiomeSource(config);
        return new LevelStem(context.dimension, (ChunkGenerator)new BCLChunkGenerator(netherSource, (Holder<NoiseGeneratorSettings>)context.generatorSettings));
    }

    public static LevelStem getBCLEndLevelStem(WorldGenUtil.Context context, BCLEndBiomeSourceConfig config) {
        BCLibEndBiomeSource endSource = new BCLibEndBiomeSource(config);
        return new LevelStem(context.dimension, (ChunkGenerator)new BCLChunkGenerator(endSource, (Holder<NoiseGeneratorSettings>)context.generatorSettings));
    }

    public static Registry<LevelStem> replaceGenerator(ResourceKey<LevelStem> dimensionKey, ResourceKey<DimensionType> dimensionTypeKey, RegistryAccess registryAccess, Registry<LevelStem> dimensionRegistry, ChunkGenerator generator) {
        Registry dimensionTypeRegistry = registryAccess.m_175515_(Registries.f_256787_);
        Registry<LevelStem> newDimensions = LevelGenUtil.withDimension(dimensionKey, dimensionTypeKey, (Registry<DimensionType>)dimensionTypeRegistry, dimensionRegistry, generator);
        return newDimensions;
    }

    public static Registry<LevelStem> withDimension(ResourceKey<LevelStem> dimensionKey, ResourceKey<DimensionType> dimensionTypeKey, Registry<DimensionType> dimensionTypeRegistry, Registry<LevelStem> inputDimensions, ChunkGenerator generator) {
        LevelStem levelStem = (LevelStem)inputDimensions.m_6246_(dimensionKey);
        Holder dimensionType = levelStem == null ? dimensionTypeRegistry.m_246971_(dimensionTypeKey) : levelStem.f_63975_();
        return LevelGenUtil.withDimension(dimensionKey, inputDimensions, new LevelStem(dimensionType, generator));
    }

    public static Registry<LevelStem> withDimension(ResourceKey<LevelStem> dimensionKey, Registry<LevelStem> inputDimensions, LevelStem levelStem) {
        MappedRegistry writableRegistry = new MappedRegistry(Registries.f_256862_, Lifecycle.experimental());
        writableRegistry.m_255290_(dimensionKey, (Object)levelStem, Lifecycle.stable());
        for (Map.Entry entry : inputDimensions.m_6579_()) {
            ResourceKey resourceKey = (ResourceKey)entry.getKey();
            if (resourceKey == dimensionKey) continue;
            writableRegistry.m_255290_(resourceKey, (Object)((LevelStem)entry.getValue()), inputDimensions.m_6228_((Object)((LevelStem)entry.getValue())));
        }
        return writableRegistry;
    }

    public static void migrateGeneratorSettings() {
        CompoundTag settingsNbt = WorldGenUtil.getPresetsNbt();
        if (settingsNbt.m_128440_() == 0) {
            Registry<LevelStem> dimensions;
            boolean isPre18;
            CompoundTag oldGen = WorldGenUtil.getGeneratorNbt();
            if (oldGen != null && oldGen.m_128441_("type")) {
                BCLib.LOGGER.info("Found World with beta generator Settings.");
                if ("bclib:bcl_world_preset_settings".equals(oldGen.m_128461_("type"))) {
                    int netherVersion = 18;
                    int endVersion = 18;
                    if (oldGen.m_128441_("minecraft:the_nether")) {
                        netherVersion = oldGen.m_128451_("minecraft:the_nether");
                    }
                    if (oldGen.m_128441_("minecraft:the_end")) {
                        endVersion = oldGen.m_128451_("minecraft:the_end");
                    }
                    netherVersion = netherVersion == 18 ? 0 : (netherVersion == 17 ? 1 : 2);
                    endVersion = endVersion == 18 ? 0 : (endVersion == 17 ? 1 : 2);
                    List<Map<ResourceKey<LevelStem>, ChunkGenerator>> presets = List.of(TogetherWorldPreset.getDimensionsMap(PresetsRegistry.BCL_WORLD), TogetherWorldPreset.getDimensionsMap(PresetsRegistry.BCL_WORLD_17), TogetherWorldPreset.getDimensionsMap((ResourceKey<WorldPreset>)WorldPresets.f_226437_));
                    HashMap<ResourceKey<LevelStem>, ChunkGenerator> dimensions2 = new HashMap<ResourceKey<LevelStem>, ChunkGenerator>();
                    dimensions2.put(LevelStem.f_63971_, presets.get(0).get(LevelStem.f_63971_));
                    dimensions2.put(LevelStem.f_63972_, presets.get(netherVersion).get(LevelStem.f_63972_));
                    dimensions2.put(LevelStem.f_63973_, presets.get(endVersion).get(LevelStem.f_63973_));
                    TogetherWorldPreset.writeWorldPresetSettingsDirect(dimensions2);
                }
                return;
            }
            BCLib.LOGGER.info("Found World without generator Settings. Setting up data...");
            ResourceKey<WorldPreset> biomeSourceVersion = PresetsRegistry.BCL_WORLD;
            CompoundTag bclRoot = WorldConfig.getRootTag("bclib");
            String bclVersion = "0.0.0";
            if (bclRoot.m_128441_(TAG_VERSION)) {
                bclVersion = bclRoot.m_128461_(TAG_VERSION);
            }
            boolean bl = isPre18 = !ModUtil.isLargerOrEqualVersion(bclVersion, "1.0.0");
            if (isPre18) {
                BCLib.LOGGER.info("World was create pre 1.18!");
                biomeSourceVersion = PresetsRegistry.BCL_WORLD_17;
            }
            if (WorldConfig.hasMod("betternether")) {
                BCLib.LOGGER.info("Found Data from BetterNether, using for migration.");
                CompoundTag bnRoot = WorldConfig.getRootTag("betternether");
                ResourceKey<WorldPreset> resourceKey = biomeSourceVersion = "1.17".equals(bnRoot.m_128461_(TAG_BN_GEN_VERSION)) ? PresetsRegistry.BCL_WORLD_17 : PresetsRegistry.BCL_WORLD;
            }
            if ((dimensions = TogetherWorldPreset.getDimensions(biomeSourceVersion)) != null) {
                BCLib.LOGGER.info("Set world to BiomeSource Version " + biomeSourceVersion);
                TogetherWorldPreset.writeWorldPresetSettings(dimensions);
            } else {
                BCLib.LOGGER.error("Failed to set world to BiomeSource Version " + biomeSourceVersion);
            }
        }
    }
}

