/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.LifeCycleAPI;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.api.v2.datafixer.DataFixerAPI;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.config.BCLEndBiomeSourceConfig;
import org.betterx.bclib.api.v2.levelgen.LevelGenUtil;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.bclib.api.v2.poi.PoiManager;
import org.betterx.bclib.registry.PresetsRegistry;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.betterx.worlds.together.world.WorldConfig;
import org.betterx.worlds.together.world.event.WorldEvents;
import org.betterx.worlds.together.worldPreset.TogetherWorldPreset;

public class LevelGenEvents {
    public static void setupWorld() {
        InternalBiomeAPI.prepareNewLevel();
        DataExchangeAPI.prepareServerside();
    }

    public static void register() {
        WorldEvents.BEFORE_WORLD_LOAD.on(LevelGenEvents::beforeWorldLoad);
        WorldEvents.ON_WORLD_LOAD.on(LevelGenEvents::onWorldLoad);
        WorldEvents.WORLD_REGISTRY_READY.on(LevelGenEvents::worldRegistryReady);
        WorldEvents.ON_FINALIZE_LEVEL_STEM.on(LevelGenEvents::finalizeStem);
        WorldEvents.ON_FINALIZED_WORLD_LOAD.on(LevelGenEvents::finalizedWorldLoad);
        WorldEvents.PATCH_WORLD.on(LevelGenEvents::patchExistingWorld);
        WorldEvents.ADAPT_WORLD_PRESET.on(LevelGenEvents::adaptWorldPreset);
        WorldEvents.BEFORE_ADDING_TAGS.on(LevelGenEvents::applyBiomeTags);
    }

    private static void applyBiomeTags(String directory, Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagsMap) {
        if (directory.equals(TagManager.BIOMES.directory)) {
            InternalBiomeAPI._runBiomeTagAdders();
        }
    }

    private static boolean patchExistingWorld(LevelStorageSource.LevelStorageAccess storageAccess, Consumer<Boolean> allDone) {
        Path dataPath = storageAccess.m_78283_(LevelResource.f_78182_).resolve("data");
        WorldConfig.setDataDir(dataPath.toFile());
        return DataFixerAPI.fixData(storageAccess, allDone != null && BCLib.isClient(), allDone);
    }

    private static Holder<WorldPreset> adaptWorldPreset(Holder<WorldPreset> currentPreset, WorldDimensions worldDims) {
        LevelStem endStem = (LevelStem)worldDims.f_243948_().m_6246_(LevelStem.f_63973_);
        if (!(endStem.f_63976_().m_62218_() instanceof BCLibEndBiomeSource) && currentPreset != null && currentPreset instanceof TogetherWorldPreset) {
            TogetherWorldPreset worldPreset = (TogetherWorldPreset)currentPreset;
            ResourceKey worldPresetKey = currentPreset.m_203543_().orElse(null);
            if (PresetsRegistry.BCL_WORLD.equals((Object)worldPresetKey) || PresetsRegistry.BCL_WORLD_17.equals((Object)worldPresetKey)) {
                BCLib.LOGGER.info("Detected Datapack for END.");
                LevelStem configuredEndStem = worldPreset.getDimension((ResourceKey<LevelStem>)LevelStem.f_63973_);
                BiomeSource biomeSource = configuredEndStem.f_63976_().m_62218_();
                if (biomeSource instanceof BCLibEndBiomeSource) {
                    BCLibEndBiomeSource endSource = (BCLibEndBiomeSource)biomeSource;
                    BCLib.LOGGER.info("Changing Default WorldPreset Settings for Datapack use.");
                    BCLEndBiomeSourceConfig inputConfig = endSource.getTogetherConfig();
                    endSource.setTogetherConfig(new BCLEndBiomeSourceConfig(inputConfig.mapVersion, BCLEndBiomeSourceConfig.EndBiomeGeneratorType.VANILLA, false, inputConfig.innerVoidRadiusSquared, inputConfig.centerBiomesSize, inputConfig.voidBiomesSize, inputConfig.landBiomesSize, inputConfig.barrensBiomesSize));
                }
            }
        }
        return currentPreset;
    }

    private static void worldRegistryReady(RegistryAccess a) {
        InternalBiomeAPI.initRegistry(a);
    }

    private static void beforeWorldLoad(LevelStorageSource.LevelStorageAccess storageAccess, Map<ResourceKey<LevelStem>, ChunkGenerator> dimensions, boolean isNewWorld, boolean isServer) {
        LevelGenEvents.setupWorld();
        if (isNewWorld) {
            WorldConfig.saveFile("bclib");
            DataFixerAPI.initializePatchData();
        } else {
            LevelGenUtil.migrateGeneratorSettings();
        }
    }

    private static void onWorldLoad() {
        LifeCycleAPI._runBeforeLevelLoad();
    }

    private static void finalizeStem(Registry<LevelStem> dimensionRegistry, ResourceKey<LevelStem> dimension, LevelStem levelStem) {
        InternalBiomeAPI.applyModifications(levelStem.f_63976_().m_62218_(), dimension);
    }

    private static void finalizedWorldLoad(Registry<LevelStem> dimensionRegistry) {
        PoiManager.updateStates();
    }
}

