/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator.map.square;

import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.interfaces.BiomeChunk;

public class SquareBiomeChunk
implements BiomeChunk {
    private static final int BIT_OFFSET = 4;
    protected static final int WIDTH = 16;
    private static final int SM_WIDTH = 8;
    private static final int SM_BIT_OFFSET = 2;
    private static final int MASK_OFFSET = 7;
    protected static final int MASK_WIDTH = 15;
    private static final int SM_CAPACITY = 64;
    private static final int CAPACITY = 256;
    private final BiomePicker.ActualBiome[] biomes;

    public SquareBiomeChunk(WorldgenRandom random, BiomePicker picker) {
        int z;
        int offset;
        int x;
        BiomePicker.ActualBiome[] PreBio = new BiomePicker.ActualBiome[64];
        this.biomes = new BiomePicker.ActualBiome[256];
        for (x = 0; x < 8; ++x) {
            offset = x << 2;
            for (z = 0; z < 8; ++z) {
                PreBio[offset | z] = picker.getBiome(random);
            }
        }
        for (x = 0; x < 16; ++x) {
            offset = x << 4;
            for (z = 0; z < 16; ++z) {
                this.biomes[offset | z] = PreBio[this.getSmIndex(this.offsetXZ(x, random), this.offsetXZ(z, random))].getSubBiome(random);
            }
        }
    }

    @Override
    public BiomePicker.ActualBiome getBiome(int x, int z) {
        return this.biomes[this.getIndex(x & 0xF, z & 0xF)];
    }

    @Override
    public void setBiome(int x, int z, BiomePicker.ActualBiome biome) {
        this.biomes[this.getIndex((int)(x & 0xF), (int)(z & 0xF))] = biome;
    }

    @Override
    public int getSide() {
        return 16;
    }

    private int offsetXZ(int x, WorldgenRandom random) {
        return x + random.m_188503_(2) >> 1 & 7;
    }

    private int getIndex(int x, int z) {
        return x << 4 | z;
    }

    private int getSmIndex(int x, int z) {
        return x << 2 | z;
    }
}

