/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.fabricmc.fabric.api.biome.v1.NetherBiomes;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.generator.BCLBiomeSource;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.generator.config.BCLNetherBiomeSourceConfig;
import org.betterx.bclib.api.v2.generator.config.MapBuilderFunction;
import org.betterx.bclib.api.v2.generator.map.MapStack;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.interfaces.BiomeMap;
import org.betterx.worlds.together.biomesource.BiomeSourceWithConfig;

public class BCLibNetherBiomeSource
extends BCLBiomeSource
implements BiomeSourceWithConfig<BCLibNetherBiomeSource, BCLNetherBiomeSourceConfig> {
    public static final Codec<BCLibNetherBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.currentSeed), (App)BCLNetherBiomeSourceConfig.CODEC.fieldOf("config").orElse((Object)BCLNetherBiomeSourceConfig.DEFAULT).forGetter(o -> o.config)).apply((Applicative)instance, instance.stable(BCLibNetherBiomeSource::new)));
    private BiomeMap biomeMap;
    private BiomePicker biomePicker;
    private BCLNetherBiomeSourceConfig config;

    public BCLibNetherBiomeSource(BCLNetherBiomeSourceConfig config) {
        this(0L, config, false);
    }

    private BCLibNetherBiomeSource(long seed, BCLNetherBiomeSourceConfig config) {
        this(seed, config, true);
    }

    private BCLibNetherBiomeSource(long seed, BCLNetherBiomeSourceConfig config, boolean initMaps) {
        super(seed);
        this.config = config;
        this.rebuildBiomes(false);
        if (initMaps) {
            this.initMap(seed);
        }
    }

    @Override
    protected BiomeAPI.BiomeType defaultBiomeType() {
        return BiomeAPI.BiomeType.NETHER;
    }

    @Override
    protected Map<BiomeAPI.BiomeType, BiomePicker> createFreshPickerMap() {
        this.biomePicker = new BiomePicker();
        return Map.of(this.defaultBiomeType(), this.biomePicker);
    }

    @Override
    protected BiomeAPI.BiomeType typeForUnknownBiome(ResourceKey<Biome> biomeKey, BiomeAPI.BiomeType defaultType) {
        if (NetherBiomes.canGenerateInNether(biomeKey)) {
            return BiomeAPI.BiomeType.NETHER;
        }
        return super.typeForUnknownBiome(biomeKey, defaultType);
    }

    public static void register() {
        Registry.m_122965_((Registry)BuiltInRegistries.f_256737_, (ResourceLocation)BCLib.makeID("nether_biome_source"), CODEC);
    }

    public Holder<Biome> m_203407_(int biomeX, int biomeY, int biomeZ, Climate.Sampler var4) {
        if (!this.wasBound()) {
            this.reloadBiomes(false);
        }
        if (this.biomeMap == null) {
            return (Holder)this.m_207840_().stream().findFirst().get();
        }
        if ((biomeX & 0x3F) == 0 && (biomeZ & 0x3F) == 0) {
            this.biomeMap.clearCache();
        }
        BiomePicker.ActualBiome bb = this.biomeMap.getBiome(biomeX << 2, biomeY << 2, biomeZ << 2);
        return bb.biome;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    @Override
    protected void onInitMap(long seed) {
        MapBuilderFunction mapConstructor = this.config.mapVersion.mapBuilder;
        this.biomeMap = (double)this.maxHeight > (double)this.config.biomeSizeVertical * 1.5 && this.config.useVerticalBiomes ? new MapStack(seed, this.config.biomeSize, this.biomePicker, this.config.biomeSizeVertical, this.maxHeight, mapConstructor) : mapConstructor.create(seed, this.config.biomeSize, this.biomePicker);
    }

    @Override
    protected void onHeightChange(int newHeight) {
        this.initMap(this.currentSeed);
    }

    @Override
    public String toShortString() {
        return "BCLib - Nether BiomeSource (" + Integer.toHexString(this.hashCode()) + ")";
    }

    public String toString() {
        return "\n" + this.toShortString() + "\n    biomes     = " + this.m_207840_().size() + "\n    namespaces = " + this.getNamespaces() + "\n    seed       = " + this.currentSeed + "\n    height     = " + this.maxHeight + "\n    config     = " + this.config;
    }

    @Override
    public BCLNetherBiomeSourceConfig getTogetherConfig() {
        return this.config;
    }

    @Override
    public void setTogetherConfig(BCLNetherBiomeSourceConfig newConfig) {
        this.config = newConfig;
        this.initMap(this.currentSeed);
    }
}

