/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.datafixer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import org.betterx.bclib.api.v2.datafixer.MigrationProfile;
import org.betterx.bclib.interfaces.PatchBiFunction;
import org.betterx.bclib.interfaces.PatchFunction;
import org.betterx.worlds.together.util.ModUtil;
import org.jetbrains.annotations.NotNull;

public abstract class Patch {
    private static final List<Patch> ALL = new ArrayList<Patch>(10);
    public final int level;
    public final String version;
    @NotNull
    public final String modID;
    public final boolean alwaysApply;

    static List<Patch> getALL() {
        return ALL;
    }

    public static String maxPatchVersion(@NotNull String modID) {
        return ALL.stream().filter(p -> p.modID.equals(modID)).map(p -> p.version).reduce((p, c) -> c).orElse("0.0.0");
    }

    public static int maxPatchLevel(@NotNull String modID) {
        return ALL.stream().filter(p -> p.modID.equals(modID)).mapToInt(p -> p.level).max().orElse(0);
    }

    protected Patch(@NotNull String modID, String version) {
        this(modID, version, false);
    }

    Patch(@NotNull String modID, String version, boolean alwaysApply) {
        if (modID == null || modID.isEmpty()) {
            throw new RuntimeException("[INTERNAL ERROR] Patches need a valid modID!");
        }
        if (version == null || version.isEmpty()) {
            throw new RuntimeException("Invalid Mod-Version");
        }
        this.version = version;
        this.alwaysApply = alwaysApply;
        this.level = ModUtil.convertModVersion(version);
        if (!ALL.stream().filter(p -> p.modID.equals(modID)).noneMatch(p -> p.level >= this.level) || this.level <= 0) {
            throw new RuntimeException("[INTERNAL ERROR] Patch-levels need to be created in ascending order beginning with 1.");
        }
        this.modID = modID;
    }

    public String toString() {
        return "Patch{" + this.modID + ":" + this.version + ":" + this.level + "}";
    }

    public Map<String, String> getIDReplacements() {
        return new HashMap<String, String>();
    }

    public PatchFunction<CompoundTag, Boolean> getLevelDatPatcher() {
        return null;
    }

    public PatchFunction<CompoundTag, Boolean> getWorldDataPatcher() {
        return null;
    }

    public PatchBiFunction<ListTag, ListTag, Boolean> getBlockStatePatcher() {
        return null;
    }

    static MigrationProfile createMigrationData(CompoundTag config) {
        return new MigrationProfile(config, false);
    }

    static MigrationProfile createMigrationData() {
        return new MigrationProfile(null, true);
    }

    public List<String> getWorldDataIDPaths() {
        return null;
    }
}

