/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import org.betterx.bclib.BCLib;
import org.jetbrains.annotations.NotNull;

public class FileHash {
    private static final int ERR_DOES_NOT_EXIST = -10;
    private static final int ERR_IO_ERROR = -20;
    @NotNull
    public final byte[] md5;
    public final int size;
    public final int value;

    FileHash(byte[] md5, int size, int value) {
        Objects.nonNull(md5);
        this.md5 = md5;
        this.size = size;
        this.value = value;
    }

    static FileHash createForEmpty(int errCode) {
        return new FileHash(new byte[0], 0, errCode);
    }

    public boolean noFile() {
        return this.md5.length == 0;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.size);
        buf.writeInt(this.value);
        buf.m_130087_(this.md5);
    }

    public static FileHash deserialize(FriendlyByteBuf buf) {
        int size = buf.readInt();
        int value = buf.readInt();
        byte[] md5 = buf.m_130052_();
        return new FileHash(md5, size, value);
    }

    public String getMd5String() {
        return FileHash.toHexString(this.md5);
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static FileHash create(File file) {
        if (!file.exists()) {
            return FileHash.createForEmpty(-10);
        }
        Path path = file.toPath();
        int size = 0;
        byte[] md5 = new byte[]{};
        int value = 0;
        try {
            byte[] data = Files.readAllBytes(path);
            size = data.length;
            int n = value = size > 0 ? data[size / 3] | data[size / 2] << 8 | data[size / 5] << 16 : -1;
            if (size > 20) {
                value |= data[20] << 24;
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(data);
            md5 = md.digest();
            return new FileHash(md5, size, value);
        }
        catch (IOException e) {
            BCLib.LOGGER.error("Failed to read file: " + file);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            BCLib.LOGGER.error("Unable to build hash for file: " + file);
            return FileHash.createForEmpty(-20);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileHash)) {
            return false;
        }
        FileHash fileHash = (FileHash)o;
        return this.size == fileHash.size && this.value == fileHash.value && Arrays.equals(this.md5, fileHash.md5);
    }

    public int hashCode() {
        int result = Objects.hash(this.size, this.value);
        result = 31 * result + Arrays.hashCode(this.md5);
        return result;
    }

    public String toString() {
        return String.format("%08x", this.size) + "-" + String.format("%08x", this.value) + "-" + this.getMd5String();
    }
}

