/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.world.biome.surface;

import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.block.ModBlocks;
import net.lyof.phantasm.mixin.NoiseGeneratorSettingsAccess;
import net.lyof.phantasm.world.biome.ModBiomes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class ModMaterialRules {
    private static final SurfaceRules.RuleSource VIVID_NIHILIUM = ModMaterialRules.block(ModBlocks.VIVID_NIHILIUM);
    private static final SurfaceRules.RuleSource RAW_PURPUR = ModMaterialRules.block(ModBlocks.RAW_PURPUR);

    private static SurfaceRules.RuleSource block(Block b) {
        return SurfaceRules.m_189390_((BlockState)b.m_49966_());
    }

    public static SurfaceRules.RuleSource createDreamingDenRule() {
        SurfaceRules.ConditionSource dreaming_den = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{ModBiomes.DREAMING_DEN});
        SurfaceRules.ConditionSource dreaming_den_noise = SurfaceRules.m_189409_((ResourceKey)Noises.f_189265_, (double)-0.2);
        SurfaceRules.ConditionSource band_noise = SurfaceRules.m_189409_((ResourceKey)Noises.f_189256_, (double)0.0);
        SurfaceRules.ConditionSource band_y_below = SurfaceRules.m_189403_((String)"obsidian_stripes_below1", (VerticalAnchor)VerticalAnchor.m_158922_((int)40), (VerticalAnchor)VerticalAnchor.m_158922_((int)42));
        SurfaceRules.ConditionSource band_y_above = SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"obsidian_stripes_above1", (VerticalAnchor)VerticalAnchor.m_158922_((int)35), (VerticalAnchor)VerticalAnchor.m_158922_((int)37)));
        SurfaceRules.ConditionSource band_y_below2 = SurfaceRules.m_189403_((String)"obsidian_stripes_below2", (VerticalAnchor)VerticalAnchor.m_158922_((int)32), (VerticalAnchor)VerticalAnchor.m_158922_((int)34));
        SurfaceRules.ConditionSource band_y_above2 = SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"obsidian_stripes_above2", (VerticalAnchor)VerticalAnchor.m_158922_((int)27), (VerticalAnchor)VerticalAnchor.m_158922_((int)29)));
        SurfaceRules.ConditionSource band_y_below3 = SurfaceRules.m_189403_((String)"obsidian_stripes_below3", (VerticalAnchor)VerticalAnchor.m_158922_((int)24), (VerticalAnchor)VerticalAnchor.m_158922_((int)26));
        SurfaceRules.ConditionSource band_y_above3 = SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"obsidian_stripes_above3", (VerticalAnchor)VerticalAnchor.m_158922_((int)19), (VerticalAnchor)VerticalAnchor.m_158922_((int)21)));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{Biomes.f_48210_})), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)band_y_above, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)band_y_below, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189409_((ResourceKey)Noises.f_189278_, (double)0.1), (SurfaceRules.RuleSource)RAW_PURPUR))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)band_y_above2, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)band_y_below2, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189409_((ResourceKey)Noises.f_189266_, (double)0.0), (SurfaceRules.RuleSource)RAW_PURPUR))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)band_y_above3, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)band_y_below3, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)band_noise, (SurfaceRules.RuleSource)RAW_PURPUR)))})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)dreaming_den, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)dreaming_den_noise, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189400_((VerticalAnchor)VerticalAnchor.m_158930_((int)50), (int)0), (SurfaceRules.RuleSource)VIVID_NIHILIUM))))});
    }

    public static void addModMaterialRules(MinecraftServer server, ResourceKey<LevelStem> dimensionKey) {
        LevelStem levelStem = (LevelStem)server.m_247573_().m_247579_().m_175515_(Registries.f_256862_).m_6246_(dimensionKey);
        if (levelStem == null) {
            Phantasm.LOGGER.error("Couldn't find the End noise generation provider");
            return;
        }
        ChunkGenerator chunkGenerator = levelStem.f_63976_();
        boolean hasEndBiomes = chunkGenerator.m_62218_().m_207840_().stream().anyMatch(biomeHolder -> ((ResourceKey)biomeHolder.m_203543_().orElseThrow()).m_135782_().m_135827_().equals("phantasm"));
        if (hasEndBiomes && chunkGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings settings = (NoiseGeneratorSettings)noiseGenerator.m_224341_().m_203334_();
            ((NoiseGeneratorSettingsAccess)settings).addSurfaceRule(SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{ModMaterialRules.createDreamingDenRule(), settings.f_188871_()}));
            Phantasm.log("Successfully added Surface Rules for the End");
        }
    }
}

