/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.setup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.setup.ModTags;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ModRegistry {
    public static List<Block> BLOCKS = new ArrayList<Block>();
    public static Map<TagKey<Block>, List<Block>> BLOCK_TAGS = new HashMap<TagKey<Block>, List<Block>>();
    public static Map<Block, ItemLike> BLOCK_DROPS = new HashMap<Block, ItemLike>();
    public static Map<Block, Block> BLOCK_STRIPPED = new HashMap<Block, Block>();
    public static Map<Block, Map<Models, Block>> BLOCK_SETS = new HashMap<Block, Map<Models, Block>>();
    public static Map<Models, List<Block>> BLOCK_MODELS = new HashMap<Models, List<Block>>();
    public static List<Block> BLOCK_CUTOUT = new ArrayList<Block>();
    public static Map<Block, Tuple<Integer, Integer>> BLOCK_FLAMMABLE = new HashMap<Block, Tuple<Integer, Integer>>();
    public static List<Item> ITEMS = new ArrayList<Item>();
    public static Map<TagKey<Item>, List<Item>> ITEM_TAGS = new HashMap<TagKey<Item>, List<Item>>();
    public static Map<Item, ModelTemplate> ITEM_MODELS = new HashMap<Item, ModelTemplate>();
    public static Map<ItemLike, Integer> ITEM_BURNABLE = new HashMap<ItemLike, Integer>();

    public static BlockBuilder ofBlock(String id, Block block) {
        return ModRegistry.ofBlock(id, block, true);
    }

    public static BlockBuilder ofBlock(String id, Block block, boolean item) {
        return new BlockBuilder(Phantasm.makeID(id), block, item);
    }

    public static ItemBuilder ofItem(String id, Item item) {
        return new ItemBuilder(Phantasm.makeID(id), item);
    }

    public static List<Block> getModelList(Models key) {
        return BLOCK_MODELS.getOrDefault((Object)key, new ArrayList());
    }

    public static void registerStairsAndSlab(Block parent, Block stairs, Block slab) {
        ModRegistry.registerSet(parent, Map.of(Models.STAIRS, stairs, Models.SLAB, slab));
    }

    public static void registerSet(Block parent, Map<Models, Block> set) {
        BLOCK_SETS.putIfAbsent(parent, set);
        for (Models model : set.keySet()) {
            BLOCK_MODELS.putIfAbsent(model, new ArrayList());
            BLOCK_MODELS.get((Object)model).add(set.get((Object)model));
        }
    }

    public static void addDrop(Block block, ItemLike loot) {
        BLOCK_DROPS.putIfAbsent(block, loot);
    }

    public static class BlockBuilder {
        protected ResourceLocation id;
        protected Block block;

        protected BlockBuilder(ResourceLocation id, Block block, boolean item) {
            this.id = id;
            this.block = (Block)Registry.m_122965_((Registry)BuiltInRegistries.f_256975_, (ResourceLocation)id, (Object)block);
            if (item) {
                ModRegistry.ofItem(id.m_135815_(), (Item)new BlockItem(block, (Item.Properties)new FabricItemSettings())).build();
            }
        }

        public Block build() {
            BLOCKS.add(this.block);
            return this.block;
        }

        public BlockBuilder drop() {
            return this.drop((ItemLike)this.block);
        }

        public BlockBuilder drop(ItemLike loot) {
            BLOCK_DROPS.putIfAbsent(this.block, loot);
            return this;
        }

        public BlockBuilder tag(TagKey<Block> tagname) {
            BLOCK_TAGS.putIfAbsent(tagname, new ArrayList());
            BLOCK_TAGS.get(tagname).add(this.block);
            return this;
        }

        @SafeVarargs
        public final BlockBuilder tag(TagKey<Block> ... tags) {
            for (TagKey<Block> tagname : tags) {
                this.tag(tagname);
            }
            return this;
        }

        public BlockBuilder tagitem(TagKey<Item> tagname) {
            ITEM_TAGS.putIfAbsent(tagname, new ArrayList());
            ITEM_TAGS.get(tagname).add(this.block.m_5456_());
            return this;
        }

        @SafeVarargs
        public final BlockBuilder tagitem(TagKey<Item> ... tags) {
            for (TagKey<Item> tagname : tags) {
                this.tagitem(tagname);
            }
            return this;
        }

        public BlockBuilder tool(String tool_material) {
            String[] needed = tool_material.split("_");
            if (needed[0].equals("stone")) {
                this.tag((TagKey<Block>)BlockTags.f_144286_);
            }
            if (needed[0].equals("iron")) {
                this.tag((TagKey<Block>)BlockTags.f_144285_);
            }
            if (needed[0].equals("diamond")) {
                this.tag((TagKey<Block>)BlockTags.f_144284_);
            }
            if (needed[1].equals("pickaxe")) {
                this.tag((TagKey<Block>)BlockTags.f_144282_);
            }
            if (needed[1].equals("axe")) {
                this.tag((TagKey<Block>)BlockTags.f_144280_);
            }
            if (needed[1].equals("shovel")) {
                this.tag((TagKey<Block>)BlockTags.f_144283_);
            }
            if (needed[1].equals("hoe")) {
                this.tag((TagKey<Block>)BlockTags.f_144281_);
            }
            if (needed[1].equals("sword")) {
                this.tag((TagKey<Block>)BlockTags.f_278398_);
            }
            return this;
        }

        public BlockBuilder end_plant() {
            return this.tag(ModTags.Blocks.END_PLANTS);
        }

        public BlockBuilder end_soil() {
            return this.tag(ModTags.Blocks.END_PLANTS_GROWABLE_ON);
        }

        public BlockBuilder model() {
            return this.model(Models.CUBE);
        }

        public BlockBuilder model(Models model) {
            BLOCK_MODELS.putIfAbsent(model, new ArrayList());
            BLOCK_MODELS.get((Object)model).add(this.block);
            return this;
        }

        public BlockBuilder model(ModelTemplate model) {
            ITEM_MODELS.put(this.block.m_5456_(), model);
            return this;
        }

        public BlockBuilder cutout() {
            BLOCK_CUTOUT.add(this.block);
            return this;
        }

        public BlockBuilder fuel(int duration) {
            ITEM_BURNABLE.put((ItemLike)this.block, duration);
            return this;
        }

        public BlockBuilder flammable(int duration, int spread) {
            BLOCK_FLAMMABLE.put(this.block, (Tuple<Integer, Integer>)new Tuple((Object)duration, (Object)spread));
            return this;
        }

        public BlockBuilder strip(Block stripped) {
            BLOCK_STRIPPED.putIfAbsent(this.block, stripped);
            return this;
        }
    }

    public static class ItemBuilder {
        protected ResourceLocation id;
        protected Item item;

        protected ItemBuilder(ResourceLocation id, Item item) {
            this.id = id;
            this.item = (Item)Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)id, (Object)item);
        }

        public Item build() {
            ITEMS.add(this.item);
            return this.item;
        }

        public ItemBuilder tag(TagKey<Item> tagname) {
            ITEM_TAGS.putIfAbsent(tagname, new ArrayList());
            ITEM_TAGS.get(tagname).add(this.item);
            return this;
        }

        @SafeVarargs
        public final ItemBuilder tag(TagKey<Item> ... tags) {
            for (TagKey<Item> tagname : tags) {
                this.tag(tagname);
            }
            return this;
        }

        public ItemBuilder model(ModelTemplate model) {
            ITEM_MODELS.put(this.item, model);
            return this;
        }

        public ItemBuilder fuel(int duration) {
            ITEM_BURNABLE.put((ItemLike)this.item, duration);
            return this;
        }
    }

    public static enum Models {
        CUBE,
        CROSS,
        PILLAR,
        WOOD,
        STAIRS,
        SLAB,
        BUTTON,
        PRESSURE_PLATE,
        FENCE,
        FENCE_GATE,
        DOOR,
        TRAPDOOR,
        SIGN,
        WALL_SIGN,
        HANGING_SIGN,
        WALL_HANGING_SIGN;

    }

    public static class Foods {
        public static final FoodProperties PREAM_BERRY = new FoodProperties.Builder().m_38765_().m_38760_(4).m_38762_(new MobEffectInstance(MobEffects.f_19601_, 1, 0, true, false), 1.0f).m_38767_();
        public static final FoodProperties CHORUS_SALAD = new FoodProperties.Builder().m_38765_().m_38760_(4).m_38767_();
    }
}

