/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.setup;

import java.util.Map;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.lyof.phantasm.datagen.ModBlockTagProvider;
import net.lyof.phantasm.datagen.ModItemTagProvider;
import net.lyof.phantasm.datagen.ModLootTableProvider;
import net.lyof.phantasm.datagen.ModModelProvider;
import net.lyof.phantasm.datagen.ModRecipeProvider;
import net.lyof.phantasm.datagen.ModWorldGenProvider;
import net.lyof.phantasm.setup.ModRegistry;
import net.lyof.phantasm.world.ModConfiguredFeatures;
import net.lyof.phantasm.world.ModPlacedFeatures;
import net.lyof.phantasm.world.biome.ModBiomes;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ModDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ModBlockTagProvider::new);
        pack.addProvider(ModItemTagProvider::new);
        pack.addProvider(ModLootTableProvider::new);
        pack.addProvider(ModModelProvider::new);
        pack.addProvider(ModRecipeProvider::new);
        pack.addProvider(ModWorldGenProvider::new);
    }

    public void buildRegistry(RegistrySetBuilder builder) {
        builder.m_254916_(Registries.f_256911_, ModConfiguredFeatures::bootstrap);
        builder.m_254916_(Registries.f_256988_, ModPlacedFeatures::bootstrap);
        builder.m_254916_(Registries.f_256952_, ModBiomes::bootstrap);
    }

    public static void registerFuels() {
        for (Map.Entry<ItemLike, Integer> entry : ModRegistry.ITEM_BURNABLE.entrySet()) {
            FuelRegistry.INSTANCE.add(entry.getKey(), (Object)entry.getValue());
        }
    }

    public static void registerBurnable() {
        FlammableBlockRegistry registry = FlammableBlockRegistry.getDefaultInstance();
        for (Map.Entry<Block, Tuple<Integer, Integer>> entry : ModRegistry.BLOCK_FLAMMABLE.entrySet()) {
            registry.add(entry.getKey(), ((Integer)entry.getValue().m_14418_()).intValue(), ((Integer)entry.getValue().m_14419_()).intValue());
        }
    }

    public static void registerStripped() {
        for (Map.Entry<Block, Block> entry : ModRegistry.BLOCK_STRIPPED.entrySet()) {
            StrippableBlockRegistry.register((Block)entry.getKey(), (Block)entry.getValue());
        }
    }
}

