/*
 * Decompiled with CFR 0.152.
 */
package net.lyof.phantasm.block;

import java.util.Map;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.type.WoodTypeBuilder;
import net.lyof.phantasm.Phantasm;
import net.lyof.phantasm.block.custom.CrystalShardBlock;
import net.lyof.phantasm.block.custom.HangingFruitBlock;
import net.lyof.phantasm.block.custom.NihiliumBlock;
import net.lyof.phantasm.item.ModItems;
import net.lyof.phantasm.setup.ModRegistry;
import net.lyof.phantasm.setup.ModTags;
import net.lyof.phantasm.world.feature.tree.PreamSaplingGenerator;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;

public class ModBlocks {
    private static final FabricBlockSettings CrystalMaterial = ModBlocks.copy(Blocks.f_50089_).luminance(4).emissiveLighting((a, b, c) -> true).nonOpaque();
    private static final FabricBlockSettings PolishedObsidianMaterial = ModBlocks.copy(Blocks.f_50080_).hardness(7.0f);
    private static final FabricBlockSettings PreamWoodMaterial = ModBlocks.copy(Blocks.f_49999_).mapColor(MapColor.f_283748_);
    private static final FabricBlockSettings PreamPlankMaterial = ModBlocks.copy(Blocks.f_50705_).mapColor(MapColor.f_283843_);
    private static final FabricBlockSettings PreamPassableMaterial = ModBlocks.copy(Blocks.f_50095_).mapColor(MapColor.f_283843_);
    private static final FabricBlockSettings PreamLeafMaterial = ModBlocks.copy(Blocks.f_50050_).mapColor(MapColor.f_283889_);
    private static final FabricBlockSettings RawPurpurMaterial = ModBlocks.copy(Blocks.f_50730_).mapColor(MapColor.f_283892_);
    public static final WoodType PREAM = new WoodTypeBuilder().register(Phantasm.makeID("pream"), BlockSetType.f_271198_);
    public static final Block FALLEN_STAR = ModRegistry.ofBlock("fallen_star", new Block((BlockBehaviour.Properties)ModBlocks.copy(Blocks.f_50090_).mapColor(MapColor.f_283744_).luminance(15))).tag(BlockTags.f_13069_, BlockTags.f_13070_).tool("stone_pickaxe").drop().model().build();
    public static final Block POLISHED_OBSIDIAN = ModRegistry.ofBlock("polished_obsidian", new Block((BlockBehaviour.Properties)PolishedObsidianMaterial)).tag((TagKey<Block>)BlockTags.f_13069_).tool("iron_pickaxe").drop().model().build();
    public static final Block POLISHED_OBSIDIAN_BRICKS = ModRegistry.ofBlock("polished_obsidian_bricks", new Block((BlockBehaviour.Properties)PolishedObsidianMaterial)).tag((TagKey<Block>)BlockTags.f_13069_).tool("iron_pickaxe").drop().build();
    public static final Block POLISHED_OBSIDIAN_BRICKS_STAIRS = ModRegistry.ofBlock("polished_obsidian_bricks_stairs", (Block)new StairBlock(POLISHED_OBSIDIAN_BRICKS.m_49966_(), (BlockBehaviour.Properties)PolishedObsidianMaterial)).tag(BlockTags.f_13069_, BlockTags.f_13030_).tagitem((TagKey<Item>)ItemTags.f_13138_).tool("iron_pickaxe").drop().cutout().build();
    public static final Block POLISHED_OBSIDIAN_BRICKS_SLAB = ModRegistry.ofBlock("polished_obsidian_bricks_slab", (Block)new SlabBlock((BlockBehaviour.Properties)PolishedObsidianMaterial)).tag(BlockTags.f_13069_, BlockTags.f_13031_).tagitem((TagKey<Item>)ItemTags.f_13139_).tool("iron_pickaxe").drop().cutout().build();
    public static final Block CRYSTAL_SHARD = ModRegistry.ofBlock("crystal_shard", new CrystalShardBlock((BlockBehaviour.Properties)ModBlocks.copy(CrystalMaterial).luminance(7).sounds(SoundType.f_56744_))).model(ModelTemplates.f_125658_).tool("_pickaxe").drop().cutout().build();
    public static final Block VOID_CRYSTAL_SHARD = ModRegistry.ofBlock("void_crystal_shard", new CrystalShardBlock((BlockBehaviour.Properties)ModBlocks.copy(CrystalMaterial).sounds(SoundType.f_56744_))).model(ModelTemplates.f_125658_).tool("_pickaxe").drop().cutout().build();
    public static final Block CRYSTAL_BLOCK = ModRegistry.ofBlock("crystal_block", new Block((BlockBehaviour.Properties)CrystalMaterial)).model().tool("_pickaxe").drop().build();
    public static final Block CRYSTAL_TILES = ModRegistry.ofBlock("crystal_tiles", new Block((BlockBehaviour.Properties)CrystalMaterial)).tool("_pickaxe").drop().build();
    public static final Block CRYSTAL_TILES_STAIRS = ModRegistry.ofBlock("crystal_tiles_stairs", (Block)new StairBlock(CRYSTAL_TILES.m_49966_(), (BlockBehaviour.Properties)CrystalMaterial)).tool("_pickaxe").drop().tag((TagKey<Block>)BlockTags.f_13030_).tagitem((TagKey<Item>)ItemTags.f_13138_).cutout().build();
    public static final Block CRYSTAL_TILES_SLAB = ModRegistry.ofBlock("crystal_tiles_slab", (Block)new SlabBlock((BlockBehaviour.Properties)CrystalMaterial)).tool("_pickaxe").drop().tag((TagKey<Block>)BlockTags.f_13031_).tagitem((TagKey<Item>)ItemTags.f_13139_).cutout().build();
    public static final Block CRYSTAL_PILLAR = ModRegistry.ofBlock("crystal_pillar", (Block)new RotatedPillarBlock((BlockBehaviour.Properties)CrystalMaterial)).model(ModRegistry.Models.PILLAR).tool("_pickaxe").drop().build();
    public static final Block VOID_CRYSTAL_BLOCK = ModRegistry.ofBlock("void_crystal_block", new Block((BlockBehaviour.Properties)CrystalMaterial)).model().tool("_pickaxe").drop().build();
    public static final Block VOID_CRYSTAL_TILES = ModRegistry.ofBlock("void_crystal_tiles", new Block((BlockBehaviour.Properties)CrystalMaterial)).tool("_pickaxe").drop().build();
    public static final Block VOID_CRYSTAL_TILES_STAIRS = ModRegistry.ofBlock("void_crystal_tiles_stairs", (Block)new StairBlock(VOID_CRYSTAL_TILES.m_49966_(), (BlockBehaviour.Properties)CrystalMaterial)).tool("_pickaxe").drop().tag((TagKey<Block>)BlockTags.f_13030_).tagitem((TagKey<Item>)ItemTags.f_13138_).cutout().build();
    public static final Block VOID_CRYSTAL_TILES_SLAB = ModRegistry.ofBlock("void_crystal_tiles_slab", (Block)new SlabBlock((BlockBehaviour.Properties)CrystalMaterial)).tool("_pickaxe").drop().tag((TagKey<Block>)BlockTags.f_13031_).tagitem((TagKey<Item>)ItemTags.f_13139_).cutout().build();
    public static final Block VOID_CRYSTAL_PILLAR = ModRegistry.ofBlock("void_crystal_pillar", (Block)new RotatedPillarBlock((BlockBehaviour.Properties)CrystalMaterial)).model(ModRegistry.Models.PILLAR).tool("_pickaxe").drop().build();
    public static final Block STRIPPED_PREAM_LOG = ModRegistry.ofBlock("stripped_pream_log", (Block)new RotatedPillarBlock((BlockBehaviour.Properties)PreamWoodMaterial)).tool("_axe").tag(BlockTags.f_13105_, ModTags.Blocks.PREAM_BLOCKS).tagitem(ItemTags.f_13181_, ModTags.Items.PREAM_LOGS).flammable(5, 5).fuel(300).drop().build();
    public static final Block PREAM_LOG = ModRegistry.ofBlock("pream_log", (Block)new RotatedPillarBlock((BlockBehaviour.Properties)PreamWoodMaterial)).tool("_axe").strip(STRIPPED_PREAM_LOG).tag(BlockTags.f_13105_, ModTags.Blocks.PREAM_BLOCKS).tagitem(ItemTags.f_13181_, ModTags.Items.PREAM_LOGS).flammable(5, 5).fuel(300).drop().build();
    public static final Block STRIPPED_PREAM_WOOD = ModRegistry.ofBlock("stripped_pream_wood", (Block)new RotatedPillarBlock((BlockBehaviour.Properties)PreamWoodMaterial)).tool("_axe").tag(BlockTags.f_13105_, ModTags.Blocks.PREAM_BLOCKS).tagitem(ItemTags.f_13181_, ModTags.Items.PREAM_LOGS).flammable(5, 5).fuel(300).drop().build();
    public static final Block PREAM_WOOD = ModRegistry.ofBlock("pream_wood", (Block)new RotatedPillarBlock((BlockBehaviour.Properties)PreamWoodMaterial)).tool("_axe").strip(STRIPPED_PREAM_WOOD).tag(BlockTags.f_13105_, ModTags.Blocks.PREAM_BLOCKS).tagitem(ItemTags.f_13181_, ModTags.Items.PREAM_LOGS).flammable(5, 5).fuel(300).drop().build();
    public static final Block PREAM_LEAVES = ModRegistry.ofBlock("pream_leaves", (Block)new LeavesBlock((BlockBehaviour.Properties)PreamLeafMaterial)).tag(BlockTags.f_13035_, ModTags.Blocks.PREAM_BLOCKS, ModTags.Blocks.HANGING_PREAM_LEAVES_GROWABLE_ON).tool("_hoe").flammable(5, 30).model().cutout().build();
    public static final Block HANGING_PREAM_LEAVES = ModRegistry.ofBlock("hanging_pream_leaves", new HangingFruitBlock((BlockBehaviour.Properties)ModBlocks.copy(PreamLeafMaterial).collidable(false), () -> ModItems.PREAM_BERRY, ModTags.Blocks.HANGING_PREAM_LEAVES_GROWABLE_ON, Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0))).tag(BlockTags.f_13035_, ModTags.Blocks.PREAM_BLOCKS).tool("_hoe").flammable(5, 30).cutout().build();
    public static final Block PREAM_PLANKS = ModRegistry.ofBlock("pream_planks", new Block((BlockBehaviour.Properties)PreamPlankMaterial)).tool("_axe").tag(BlockTags.f_13090_, ModTags.Blocks.PREAM_BLOCKS).tagitem((TagKey<Item>)ItemTags.f_13168_).flammable(5, 20).fuel(300).drop().build();
    public static final Block PREAM_STAIRS = ModRegistry.ofBlock("pream_stairs", (Block)new StairBlock(PREAM_PLANKS.m_49966_(), (BlockBehaviour.Properties)PreamPlankMaterial)).tool("_axe").tag(BlockTags.f_13096_, ModTags.Blocks.PREAM_BLOCKS).tagitem((TagKey<Item>)ItemTags.f_13174_).flammable(5, 20).fuel(300).drop().build();
    public static final Block PREAM_SLAB = ModRegistry.ofBlock("pream_slab", (Block)new SlabBlock((BlockBehaviour.Properties)PreamPlankMaterial)).tool("_axe").tag(BlockTags.f_13097_, ModTags.Blocks.PREAM_BLOCKS).tagitem((TagKey<Item>)ItemTags.f_13175_).flammable(5, 20).fuel(300).drop().build();
    public static final Block PREAM_PRESSURE_PLATE = ModRegistry.ofBlock("pream_pressure_plate", (Block)new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, (BlockBehaviour.Properties)PreamPassableMaterial, BlockSetType.f_271198_)).tool("_axe").tag(BlockTags.f_13100_, BlockTags.f_13081_, ModTags.Blocks.PREAM_BLOCKS).tagitem((TagKey<Item>)ItemTags.f_13177_).fuel(300).drop().build();
    public static final Block PREAM_BUTTON = ModRegistry.ofBlock("pream_button", (Block)new ButtonBlock((BlockBehaviour.Properties)PreamPassableMaterial, BlockSetType.f_271198_, 10, true)).tool("_axe").tag(BlockTags.f_13092_, ModTags.Blocks.PREAM_BLOCKS).tagitem((TagKey<Item>)ItemTags.f_13170_).fuel(100).drop().build();
    public static final Block PREAM_FENCE = ModRegistry.ofBlock("pream_fence", (Block)new FenceBlock((BlockBehaviour.Properties)PreamPlankMaterial)).tool("_axe").tag(BlockTags.f_13098_, ModTags.Blocks.PREAM_BLOCKS).tagitem((TagKey<Item>)ItemTags.f_13176_).flammable(5, 5).fuel(300).drop().build();
    public static final Block PREAM_FENCE_GATE = ModRegistry.ofBlock("pream_fence_gate", (Block)new FenceGateBlock((BlockBehaviour.Properties)PreamPlankMaterial, PREAM)).tool("_axe").tag(BlockTags.f_13098_, BlockTags.f_13055_, BlockTags.f_13056_, ModTags.Blocks.PREAM_BLOCKS).tagitem(ItemTags.f_13176_, ItemTags.f_254662_).flammable(5, 5).fuel(300).drop().build();
    public static final Block PREAM_DOOR = ModRegistry.ofBlock("pream_door", (Block)new DoorBlock((BlockBehaviour.Properties)ModBlocks.copy(Blocks.f_50154_).mapColor(MapColor.f_283843_), BlockSetType.f_271198_)).tool("_axe").tag(BlockTags.f_13095_, ModTags.Blocks.PREAM_BLOCKS).tagitem((TagKey<Item>)ItemTags.f_13173_).model(ModRegistry.Models.DOOR).cutout().drop().build();
    public static final Block PREAM_TRAPDOOR = ModRegistry.ofBlock("pream_trapdoor", (Block)new TrapDoorBlock((BlockBehaviour.Properties)ModBlocks.copy(Blocks.f_50216_).mapColor(MapColor.f_283843_), BlockSetType.f_271198_)).tool("_axe").tag(BlockTags.f_13102_, ModTags.Blocks.PREAM_BLOCKS).tagitem((TagKey<Item>)ItemTags.f_13178_).model(ModRegistry.Models.TRAPDOOR).cutout().drop().build();
    public static final Block PREAM_SIGN = ModRegistry.ofBlock("pream_sign", (Block)new StandingSignBlock((BlockBehaviour.Properties)PreamPassableMaterial, PREAM), false).tag(BlockTags.f_13068_, BlockTags.f_13066_, BlockTags.f_13081_, ModTags.Blocks.PREAM_BLOCKS).tool("_axe").drop((ItemLike)ModItems.PREAM_SIGN).build();
    public static final Block PREAM_WALL_SIGN = ModRegistry.ofBlock("pream_wall_sign", (Block)new WallSignBlock((BlockBehaviour.Properties)PreamPassableMaterial, PREAM), false).tag(BlockTags.f_13068_, BlockTags.f_13067_, BlockTags.f_13081_).tool("_axe").drop((ItemLike)ModItems.PREAM_SIGN).build();
    public static final Block PREAM_HANGING_SIGN = ModRegistry.ofBlock("pream_hanging_sign", (Block)new CeilingHangingSignBlock((BlockBehaviour.Properties)PreamPassableMaterial, PREAM), false).tag(BlockTags.f_244320_, BlockTags.f_243838_, ModTags.Blocks.PREAM_BLOCKS).tool("_axe").build();
    public static final Block PREAM_WALL_HANGING_SIGN = ModRegistry.ofBlock("pream_wall_hanging_sign", (Block)new WallHangingSignBlock((BlockBehaviour.Properties)ModBlocks.copy(PreamPassableMaterial), PREAM), false).tag(BlockTags.f_244320_, BlockTags.f_244544_, ModTags.Blocks.PREAM_BLOCKS).tool("_axe").build();
    public static final Block PREAM_SAPLING = ModRegistry.ofBlock("pream_sapling", (Block)new SaplingBlock((AbstractTreeGrower)new PreamSaplingGenerator(), (BlockBehaviour.Properties)ModBlocks.copy(Blocks.f_50746_).mapColor(MapColor.f_283889_).hardness(0.0f))).model(ModRegistry.Models.CROSS).cutout().tag(BlockTags.f_13104_, ModTags.Blocks.PREAM_BLOCKS).tagitem((TagKey<Item>)ItemTags.f_13180_).end_plant().fuel(100).drop().build();
    public static final Block VIVID_NIHILIUM = ModRegistry.ofBlock("vivid_nihilium", new NihiliumBlock((BlockBehaviour.Properties)ModBlocks.copy(Blocks.f_50259_).mapColor(MapColor.f_283745_).ticksRandomly())).tool("_pickaxe").tag((TagKey<Block>)BlockTags.f_13069_).end_soil().cutout().build();
    public static final Block VIVID_NIHILIS = ModRegistry.ofBlock("vivid_nihilis", (Block)new BushBlock((BlockBehaviour.Properties)ModBlocks.copy(Blocks.f_50693_).mapColor(MapColor.f_283745_))).tagitem((TagKey<Item>)ItemTags.f_13149_).model(ModRegistry.Models.CROSS).end_plant().cutout().build();
    public static final Block RAW_PURPUR = ModRegistry.ofBlock("raw_purpur", new Block((BlockBehaviour.Properties)RawPurpurMaterial)).tool("_pickaxe").tag((TagKey<Block>)BlockTags.f_13069_).tagitem(ItemTags.f_13166_, ItemTags.f_13165_).drop().model().build();
    public static final Block RAW_PURPUR_BRICKS = ModRegistry.ofBlock("raw_purpur_bricks", new Block((BlockBehaviour.Properties)RawPurpurMaterial)).tool("_pickaxe").tag((TagKey<Block>)BlockTags.f_13069_).drop().build();
    public static final Block RAW_PURPUR_BRICKS_STAIRS = ModRegistry.ofBlock("raw_purpur_bricks_stairs", (Block)new StairBlock(RAW_PURPUR_BRICKS.m_49966_(), (BlockBehaviour.Properties)RawPurpurMaterial)).tool("_pickaxe").tag(BlockTags.f_13069_, BlockTags.f_13030_).tagitem((TagKey<Item>)ItemTags.f_13138_).drop().build();
    public static final Block RAW_PURPUR_BRICKS_SLAB = ModRegistry.ofBlock("raw_purpur_bricks_slab", (Block)new SlabBlock((BlockBehaviour.Properties)RawPurpurMaterial)).tool("_pickaxe").tag(BlockTags.f_13069_, BlockTags.f_13031_).tagitem((TagKey<Item>)ItemTags.f_13139_).drop().build();
    public static final Block RAW_PURPUR_TILES = ModRegistry.ofBlock("raw_purpur_tiles", new Block((BlockBehaviour.Properties)RawPurpurMaterial)).model().tool("_pickaxe").tag((TagKey<Block>)BlockTags.f_13069_).drop().build();
    public static final Block RAW_PURPUR_PILLAR = ModRegistry.ofBlock("raw_purpur_pillar", (Block)new RotatedPillarBlock((BlockBehaviour.Properties)RawPurpurMaterial)).model(ModRegistry.Models.PILLAR).tool("_pickaxe").tag((TagKey<Block>)BlockTags.f_13069_).drop().build();
    public static final Block PURPUR_LAMP = ModRegistry.ofBlock("purpur_lamp", new Block((BlockBehaviour.Properties)ModBlocks.copy(Blocks.f_50492_).luminance(15))).tool("_pickaxe").drop().build();

    public static void register() {
        Phantasm.log("Registering Blocks for modid : phantasm");
        ModRegistry.addDrop(PREAM_SIGN, (ItemLike)ModItems.PREAM_SIGN);
        ModRegistry.addDrop(PREAM_WALL_SIGN, (ItemLike)ModItems.PREAM_SIGN);
        ModRegistry.addDrop(PREAM_HANGING_SIGN, (ItemLike)ModItems.PREAM_HANGING_SIGN);
        ModRegistry.addDrop(PREAM_WALL_HANGING_SIGN, (ItemLike)ModItems.PREAM_HANGING_SIGN);
        ModRegistry.registerStairsAndSlab(CRYSTAL_TILES, CRYSTAL_TILES_STAIRS, CRYSTAL_TILES_SLAB);
        ModRegistry.registerStairsAndSlab(VOID_CRYSTAL_TILES, VOID_CRYSTAL_TILES_STAIRS, VOID_CRYSTAL_TILES_SLAB);
        ModRegistry.registerStairsAndSlab(POLISHED_OBSIDIAN_BRICKS, POLISHED_OBSIDIAN_BRICKS_STAIRS, POLISHED_OBSIDIAN_BRICKS_SLAB);
        ModRegistry.registerStairsAndSlab(RAW_PURPUR_BRICKS, RAW_PURPUR_BRICKS_STAIRS, RAW_PURPUR_BRICKS_SLAB);
        ModRegistry.registerSet(PREAM_LOG, Map.of(ModRegistry.Models.WOOD, PREAM_WOOD));
        ModRegistry.registerSet(STRIPPED_PREAM_LOG, Map.of(ModRegistry.Models.WOOD, STRIPPED_PREAM_WOOD));
        ModRegistry.registerSet(PREAM_PLANKS, Map.of(ModRegistry.Models.STAIRS, PREAM_STAIRS, ModRegistry.Models.SLAB, PREAM_SLAB, ModRegistry.Models.BUTTON, PREAM_BUTTON, ModRegistry.Models.PRESSURE_PLATE, PREAM_PRESSURE_PLATE, ModRegistry.Models.FENCE, PREAM_FENCE, ModRegistry.Models.FENCE_GATE, PREAM_FENCE_GATE, ModRegistry.Models.SIGN, PREAM_SIGN, ModRegistry.Models.WALL_SIGN, PREAM_WALL_SIGN, ModRegistry.Models.HANGING_SIGN, PREAM_HANGING_SIGN, ModRegistry.Models.WALL_HANGING_SIGN, PREAM_WALL_HANGING_SIGN));
    }

    private static FabricBlockSettings copy(FabricBlockSettings original) {
        return FabricBlockSettings.copyOf((BlockBehaviour.Properties)original);
    }

    private static FabricBlockSettings copy(Block original) {
        return FabricBlockSettings.copyOf((BlockBehaviour)original);
    }
}

